<?php

namespace Main\Controllers\Store;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class StoreController extends Controller
{
		protected string $route_type = 'store';
	
		public function __construct()
		{
			if (modules('store')->settings('redirect') != '') {
				redirect(modules('store')->settings('redirect'));
			}
		}
		
    public function index()
    {
	      SeoService::set('store.index');
				
        $purchasedProductsIDs = [];

        if (auth()->check()) {
            $purchasedProductsIDs = db()->prepare("SELECT productID FROM PurchasedProducts WHERE accountID = ? AND (expiresAt > ? OR expiresAt IS NULL)");
            $purchasedProductsIDs->execute(array(auth()->user()->id(), datetime()));
            $purchasedProductsIDs = $purchasedProductsIDs->fetchAll(PDO::FETCH_COLUMN);
        }

        $categories = db()->prepare("SELECT * FROM ProductCategories WHERE parentID = ? AND isActive = ? ORDER BY priority DESC");
        $categories->execute([0, 1]);
        $categories = array_map(function ($category) use ($purchasedProductsIDs) {
					$category["image"] = '/assets/core/images/store/categories/' . $category["imageID"] . '.' . $category["imageType"];
	        
	        $categoryRequiredProducts = db()->prepare("SELECT productID FROM ProductCategoryRequiredProducts WHERE categoryID = ?");
	        $categoryRequiredProducts->execute(array($category["id"]));
	        $categoryRequiredProducts = $categoryRequiredProducts->fetchAll(PDO::FETCH_COLUMN);
	        if ($categoryRequiredProducts && (!auth()->check() || empty(array_intersect($purchasedProductsIDs, $categoryRequiredProducts)))) {
		        return null;
	        }
					
					return $category;
        }, $categories->fetchAll(PDO::FETCH_ASSOC));
				$categories = array_filter($categories);
	    
	      $communityGoalProgress = modules('store')->settings('communityGoalStatus') == '1' ? intval((100 * modules('store')->settings('communityGoalCurrent')) / modules('store')->settings('communityGoalTarget')) : 0;

        return $this->view('store.index', compact('categories', 'purchasedProductsIDs', 'communityGoalProgress'));
    }
}