<?php

namespace Main\Controllers\Suggestion;

use Main\Core\Controller;
use Main\Services\SeoService;
use PDO;

class ReplyController extends Controller
{
		protected string $route_type = 'suggestions';
	
    public function edit($id)
    {
        if (!auth()->user()->can('MANAGE_SUGGESTIONS')) {
            $reply = db()->prepare("SELECT * FROM SuggestionReplies WHERE id = ? AND accountID = ?");
            $reply->execute(array($id, auth()->user()->id()));
            $reply = $reply->fetch();
        } else {
            $reply = db()->prepare("SELECT * FROM SuggestionReplies WHERE id = ?");
            $reply->execute(array($id));
            $reply = $reply->fetch();
        }
				
        if (!$reply) abort_404();
	    
	      SeoService::set('suggestions.replies.edit');

        $suggestion = db()->prepare("SELECT * FROM Suggestions WHERE id = ?");
        $suggestion->execute(array($reply["suggestionID"]));
        $suggestion = $suggestion->fetch();
				
        if (!$suggestion) abort_404();
				
        return $this->view('suggestions.replies.edit', compact('reply', 'suggestion'));
    }

    public function update($id)
    {
        if (!auth()->user()->can('MANAGE_SUGGESTIONS')) {
		        $reply = db()->prepare("SELECT SC.id, SC.suggestionID, S.slug as suggestionSlug FROM SuggestionReplies SC INNER JOIN Suggestions S ON SC.suggestionID = S.id WHERE SC.id = ? AND SC.accountID = ?");
            $reply->execute(array($id, auth()->user()->id()));
            $reply = $reply->fetch();
        } else {
		        $reply = db()->prepare("SELECT SC.id, SC.suggestionID, S.slug as suggestionSlug FROM SuggestionReplies SC INNER JOIN Suggestions S ON SC.suggestionID = S.id WHERE SC.id = ?");
            $reply->execute(array($id));
            $reply = $reply->fetch();
        }

        if (!$reply) abort_404();

        validate([
            "message" => "required"
        ]);

        $updateReply = db()->prepare("UPDATE SuggestionReplies SET message = ?, updatedDate = ? WHERE id = ?");
        $updateReply->execute(array(input("message"), datetime(), $reply["id"]));

        redirect(url("suggestions.show", ["id" => $reply["suggestionID"], "slug" => $reply["suggestionSlug"]]));
    }

    public function destroy($id)
    {
        if (!auth()->user()->can('MANAGE_SUGGESTIONS')) {
            $reply = db()->prepare("SELECT SC.id, SC.suggestionID, S.slug as suggestionSlug FROM SuggestionReplies SC INNER JOIN Suggestions S ON SC.suggestionID = S.id WHERE SC.id = ? AND SC.accountID = ?");
            $reply->execute(array($id, auth()->user()->id()));
            $reply = $reply->fetch();
        } else {
            $reply = db()->prepare("SELECT SC.id, SC.suggestionID, S.slug as suggestionSlug FROM SuggestionReplies SC INNER JOIN Suggestions S ON SC.suggestionID = S.id WHERE SC.id = ?");
            $reply->execute(array($id));
            $reply = $reply->fetch();
        }

        if (!$reply) abort_404();

        $deleteReply = db()->prepare("DELETE FROM SuggestionReplies WHERE id = ?");
        $deleteReply->execute(array($reply["id"]));

        redirect(url("suggestions.show", ["id" => $reply["suggestionID"], "slug" => $reply["suggestionSlug"]]));
    }
}