<?php

namespace Main\Controllers\Support;

use Main\Core\Jobs\JobDispatcher;
use Main\Jobs\SendDiscordWebhook;
use Main\Libs\Discord;
use Exception;
use Main\Core\Controller;
use Main\Services\AvatarService;
use Main\Services\CkEditorImageUploadService;
use Main\Services\SeoService;

class TicketController extends Controller
{
		protected string $route_type = 'support';
		
    public function index()
    {
	      SeoService::set('support.tickets.index');
				
        $tickets = db()->prepare("SELECT S.*, SC.name as categoryName FROM Supports S INNER JOIN SupportCategories SC ON S.categoryID = SC.id WHERE S.accountID = ? ORDER BY S.updateDate DESC");
		    $tickets->execute(array(auth()->user()->id()));
		    $tickets = $tickets->fetchAll();

        return $this->view('tickets.index', compact('tickets'));
    }

    public function create()
    {
	      SeoService::set('support.tickets.create');
				
				if (modules('support')->settings('ticketsLimit') != "-1") {
					$ticketsCount = db()->prepare("SELECT COUNT(S.id) as ticketsCount FROM Supports S INNER JOIN SupportCategories SC ON S.categoryID = SC.id WHERE S.accountID = ? AND S.statusID != 4");
					$ticketsCount->execute(array(auth()->user()->id()));
					$ticketsCount = $ticketsCount->fetch();
					
					if ($ticketsCount['ticketsCount'] >= (int)modules('support')->settings('ticketsLimit')) {
						return back()->flash('error', t__("You can't open more tickets. Please wait for the staff to respond to your existing tickets."));
					}
				}
			
	      $categories = db()->query("SELECT * FROM SupportCategories");
        $categories = array_map(function ($category) {
	        $fields = db()->prepare("SELECT * FROM CustomSupportFields WHERE categoryId = ? AND isEnabled = ? ORDER BY id ASC");
	        $fields->execute(array($category["id"], 1));
					$category["fields"] = $fields->fetchAll();
					
					return $category;
				}, $categories->fetchAll());

        return $this->view('tickets.create', compact('categories'));
    }

    public function store()
    {
        validate([
            "title" => "required",
            "categoryID" => "required",
            "message" => "required"
        ]);
	    
		    if (recaptcha()->isEnabled('open_ticket') && !recaptcha()->verify()) {
			    return back()->flash('error', t__('Spam detected!'));
		    }
	    
		    $supportCategory = db()->prepare("SELECT * FROM SupportCategories WHERE id = ?");
		    $supportCategory->execute(array(input("categoryID")));
		    $supportCategory = $supportCategory->fetch();
				if (!$supportCategory) abort_404();
	    
		    if (modules('support')->settings('ticketsLimit') != "-1") {
			    $ticketsCount = db()->prepare("SELECT COUNT(S.id) as ticketsCount FROM Supports S INNER JOIN SupportCategories SC ON S.categoryID = SC.id WHERE S.accountID = ? AND S.statusID != 4");
			    $ticketsCount->execute(array(auth()->user()->id()));
			    $ticketsCount = $ticketsCount->fetch();
			    
			    if ($ticketsCount['ticketsCount'] >= (int)modules('support')->settings('ticketsLimit')) {
				    return back()->flash('error', t__("You can't open more tickets. Please wait for the staff to respond to your existing tickets."));
			    }
		    }

        $supportBannedStatus = db()->prepare("SELECT * FROM BannedAccounts WHERE accountID = ? AND categoryID = ? AND (expiryDate > ? OR expiryDate = ?)");
        $supportBannedStatus->execute(array(auth()->user()->id(), 2, datetime(), '1000-01-01 00:00:00'));
        $supportBannedStatus = $supportBannedStatus->fetch();

        if ($supportBannedStatus) {
            return back()->flash('error', t__('You are banned from support!'));
        }
				
				$title = sanitize(input("title"));

        $insertSupports = db()->prepare("INSERT INTO Supports (title, accountID, categoryID, statusID, readStatus, updateDate, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $insertSupports->execute(array($title, auth()->user()->id(), $supportCategory["id"], 1, 1, datetime(), datetime()));
        $supportID = db()->lastInsertId();

        $insertSupportMessages = db()->prepare("INSERT INTO SupportMessages (supportID, accountID, message, writeLocation, creationDate) VALUES (?, ?, ?, ?, ?)");
        $insertSupportMessages->execute(array($supportID, auth()->user()->id(), input("message"), 1, datetime()));

        $fieldsForChecking = db()->prepare("SELECT * FROM CustomSupportFields WHERE categoryID = ? AND isEnabled = ? ORDER BY id ASC");
        $fieldsForChecking->execute(array($supportCategory["id"], 1));
        $fieldsForChecking = $fieldsForChecking->fetchAll();
        foreach ($fieldsForChecking as $fieldsForChecking) {
            if ($fieldsForChecking["type"] == 4) {
                foreach ($_POST["field-" . $fieldsForChecking["id"]] as $key => $value) {
                    $field = sanitize($_POST["field-" . $fieldsForChecking["id"]][$key]);
                    $insertFieldValue = db()->prepare("INSERT INTO CustomSupportFieldValues (supportID, fieldID, value) VALUES (?, ?, ?)");
                    $insertFieldValue->execute(array($supportID, $fieldsForChecking["id"], $field));
                }
            } else {
                $field = sanitize(input("field-" . $fieldsForChecking["id"]));
                $insertFieldValue = db()->prepare("INSERT INTO CustomSupportFieldValues (supportID, fieldID, value) VALUES (?, ?, ?)");
                $insertFieldValue->execute(array($supportID, $fieldsForChecking["id"], $field));
            }
        }

        $notificationsVariables = $supportID;
        $insertNotifications = db()->prepare("INSERT INTO Notifications (accountID, type, variables, creationDate) VALUES (?, ?, ?, ?)");
        $insertNotifications->execute(array(auth()->user()->id(), 1, $notificationsVariables, datetime()));
	    
		    JobDispatcher::dispatch((new SendDiscordWebhook('support.ticket.opened', [
			    "username" => auth()->user()->displayName(),
			    "title" => $title,
			    "category" => $supportCategory["name"],
			    "message" => input("message"),
			    "dashboard_url" => website_url('/dashboard/support/tickets/' . $supportID),
		    ])));

        if (modules('discord')->isActive() && modules('discord')->settings('ticketStatus') == '1') {
            $supportCustomFields = db()->prepare("SELECT CSFV.value, CSV.field FROM CustomSupportFieldValues CSFV INNER JOIN CustomSupportFields CSV ON CSV.id = CSFV.fieldID WHERE CSFV.supportID = ?");
            $supportCustomFields->execute(array($supportID));
            $supportCustomFields = $supportCustomFields->fetchAll();

            $discord = new Discord(modules('discord')->settings('clientID'), modules('discord')->settings('clientSecret'), modules('discord')->settings('botToken'));
            $discordTicketRequest = $discord->createTicket(
                modules('discord')->settings('guildID'),
                modules('discord')->settings('ticketCategoryID'),
                $supportID,
                $supportCustomFields,
                $supportCategory["name"],
	              $title,
                input("message"),
                auth()->user()->displayName(),
                auth()->user()->data("discordUserID"),
                modules('discord')->settings('everyoneRoleID'),
                modules('discord')->settings('ticketStaffRoleID'),
                modules('discord')->settings('ticketEmbedDetailsTemplate'),
            );
            if ($discordTicketRequest->id != null) {
                $updateSupports = db()->prepare("UPDATE Supports SET discordChannelID = ? WHERE id = ?");
                $updateSupports->execute(array($discordTicketRequest->id, $supportID));
            }
        }
				
				// AI Module
	      if (modules('ai')->isActive() && modules('ai')->settings('autoReply') == '1') {
					$insertAiPlaceholderMessage = db()->prepare("INSERT INTO SupportMessages (supportID, accountID, message, writeLocation, creationDate) VALUES (?, ?, ?, ?, ?)");
					$insertAiPlaceholderMessage->execute(array($supportID, 0, t__('Writing...'), 2, datetime()));
	      }

        redirect(url('support.tickets.show', ['id' => $supportID]));
    }

    public function show($id)
    {
		    $ticket = db()->prepare("SELECT S.*, A.username, A.realname, SC.name as categoryName FROM Supports S INNER JOIN Accounts A ON S.accountID = A.id INNER JOIN SupportCategories SC ON S.categoryID = SC.id WHERE S.id = ? AND S.accountID = ?");
		    $ticket->execute(array($id, auth()->user()->id()));
		    $ticket = $ticket->fetch();

        if (!$ticket) abort_404();
	    
		    SeoService::set('support.tickets.show', [
			    'ticket_title' => $ticket['title'],
		    ]);

        $updateTicketReadStatus = db()->prepare("UPDATE Supports SET readStatus = ? WHERE id = ? AND accountID = ?");
		    $updateTicketReadStatus->execute(array(1, $id, auth()->user()->id()));

        $supportMessages = db()->prepare("SELECT SM.* FROM SupportMessages SM WHERE SM.supportID = ? ORDER BY SM.creationDate ASC");
        $supportMessages->execute(array($id));
        $ticket["messages"] = array_map(function ($message) use ($ticket) {
	        // Get user information
	        if ($message["accountID"] == '0') {
		        $message["user"] = [
			        'id' => $message['accountID'],
			        'username' => modules('ai')->settings('name'),
			        'displayName' => modules('ai')->settings('name'),
			        'avatar' => '/assets/core/images/avatars/ai.png',
		        ];
	        } else {
		        $messageUser = db()->prepare("SELECT id, username, realname FROM Accounts WHERE id = ?");
		        $messageUser->execute(array($message['accountID']));
		        $messageUser = $messageUser->fetch();
		        if ($messageUser) {
			        $message["user"] = [
				        'id' => $messageUser['id'],
				        'username' => $messageUser['username'],
				        'displayName' => $messageUser['realname'],
				        'avatar' => AvatarService::get($messageUser['id'], $messageUser['realname']),
			        ];
		        } else {
			        $message["user"] = [
				        'id' => null,
				        'username' => 'Deleted User',
				        'realname' => 'Deleted User',
				        'avatar' => AvatarService::DEFAULT_AVATAR,
			        ];
		        }
	        }
					
	        if ($message["writeLocation"] == 1) {
		        $message["content"] = markdown()->convertToHtml($message["message"]);
	        }
	        else {
		        $search = array("%username%", "%message%", "%servername%", "%serverip%", "%serverversion%");
						$staffMessage = $message["message"];
						if ($message["user"]['id'] == '0') {
							if ($staffMessage !== "..." && $staffMessage !== t__('Writing...')) {
								$staffMessage .= "\n\n" . t__("This response was generated by AI. If this answer doesn't fully resolve your issue, please reply to this ticket and our support team will assist you further.");
							}
							$staffMessage = markdown()->convertToHtml($staffMessage);
						}
		        $replace = array($ticket["realname"], $staffMessage, settings('serverName'), settings('serverIP'), settings('serverVersion'));
		        $template = modules('support')->settings('messageTemplate');
		        $message["content"] = str_replace($search, $replace, $template);
	        }
					
					return $message;
        }, $supportMessages->fetchAll());

        $supportFieldValues = db()->prepare("SELECT CSFV.value, CSV.field FROM CustomSupportFieldValues CSFV INNER JOIN CustomSupportFields CSV ON CSV.id = CSFV.fieldID WHERE CSFV.supportID = ?");
        $supportFieldValues->execute(array($ticket["id"]));
		    $ticket["fields"] = $supportFieldValues->fetchAll();

        return $this->view('tickets.show', compact('ticket'));
    }

    public function destroy($id)
    {
        /*$deleteSupports = db()->prepare("DELETE FROM Supports WHERE id = ? AND accountID = ?");
        $deleteSupports->execute(array($id, auth()->user()->id()));

        redirect(url("support.tickets.index"));*/
    }

    public function reply($id)
    {
        $support = db()->prepare("SELECT S.*, A.username, A.realname, SC.name as categoryName FROM Supports S INNER JOIN Accounts A ON S.accountID = A.id INNER JOIN SupportCategories SC ON S.categoryID = SC.id WHERE S.id = ? AND S.accountID = ?");
        $support->execute(array($id, auth()->user()->id()));
        $support = $support->fetch();

        if (!$support) abort_404();
				
				if ($support["statusID"] == 4) {
					return back()->flash('error', t__("The ticket is closed. You can't send a message."));
				}

        validate([
            "message" => "required"
        ]);
				
				if (recaptcha()->isEnabled('reply_ticket') && !recaptcha()->verify()) {
						return back()->flash('error', t__('Spam detected!'));
				}

        $supportBannedStatus = db()->prepare("SELECT * FROM BannedAccounts WHERE accountID = ? AND categoryID = ? AND (expiryDate > ? OR expiryDate = ?)");
        $supportBannedStatus->execute(array(auth()->user()->id(), 2, datetime(), '1000-01-01 00:00:00'));
        $supportBannedStatus = $supportBannedStatus->fetch();

        if ($supportBannedStatus) {
            return back()->flash('error', t__('You are banned from support!'));
        }

        $insertSupportMessages = db()->prepare("INSERT INTO SupportMessages (accountID, message, supportID, writeLocation, creationDate) VALUES (?, ?, ?, ?, ?)");
        $insertSupportMessages->execute(array(auth()->user()->id(), input("message"), $support["id"], 1, datetime()));
        $updateSupports = db()->prepare("UPDATE Supports SET updateDate = ?, statusID = ?, readStatus = ? WHERE id = ? AND accountID = ?");
        $updateSupports->execute(array(datetime(), 3, 1, $support["id"], auth()->user()->id()));
        $insertNotifications = db()->prepare("INSERT INTO Notifications (accountID, type, variables, creationDate) VALUES (?, ?, ?, ?)");
        $insertNotifications->execute(array(auth()->user()->id(), 1, $support["id"], datetime()));
	    
		    JobDispatcher::dispatch((new SendDiscordWebhook('support.ticket.replied', [
			    "username" => auth()->user()->displayName(),
			    "title" => $support["title"],
			    "category" => $support["categoryName"],
			    "message" => input("message"),
			    "url" => website_url(url('support.tickets.show', ['id' => $support["id"]])),
			    "dashboard_url" => website_url('/dashboard/support/tickets/' . $support["id"]),
		    ])));
				
        if (modules('discord')->isActive() && modules('discord')->settings('ticketStatus') == '1' && $support["discordChannelID"] != null) {
            $discord = new Discord(modules('discord')->settings('clientID'), modules('discord')->settings('clientSecret'), modules('discord')->settings('botToken'));
            $discord->sendTicketMessage($support["discordChannelID"], auth()->user()->id(), auth()->user()->displayName(), input("message"));
        }

        return back()->flash('success', t__('Your message has been sent to us successfully. It will be answered by the staff as soon as possible.'));
    }

    public function close($id)
    {
        $closeSupport = db()->prepare("UPDATE Supports SET statusID = ? WHERE id = ? AND accountID = ?");
        $closeSupport->execute(array(4, $id, auth()->user()->id()));

        redirect(url("support.tickets.index"));
    }
		
		public function upload()
		{
			try {
				$image = CkEditorImageUploadService::upload($_FILES["upload"], "/apps/main/public/images/support/uploads/");
				response()->json([
					'url' => '/assets/core/images/support/uploads/' . $image,
				]);
			} catch (Exception $e) {
				response()->json([
					'status' => false,
					'error'  => $e->getMessage(),
				]);
			}
		}
}