<?php
  
  namespace Main\Controllers\TFA;
  
  use Exception;
  use Main\Core\Controller;
  use Main\Core\Jobs\JobDispatcher;
  use Main\Core\Redirect;
  use Main\Jobs\SendEmail;
  use Main\Services\SeoService;
  
  class RecoverController extends Controller
  {
	  protected string $route_type = 'tfa';
		
	  public function __construct()
	  {
			// Block access if the user has not enabled TFA
		  $checkTfaKeys = db()->prepare("SELECT * FROM AccountTfaKeys WHERE accountID = ?");
		  $checkTfaKeys->execute([auth()->user()->id()]);
		  if ($checkTfaKeys->rowCount() == 0) abort_404();
	  }
		
    public function index()
    {
	    SeoService::set('tfa.recover.index');
			
	    return $this->view('tfa.recover');
    }
	  
	  public function send()
	  {
			validate([
				'email' => 'required|email'
			]);
			
			if (auth()->user()->email() !== input('email')) {
				return back()->flash('error', t__('Email is invalid!'));
			}
			
		  try {
			  $recoverRequest = db()->prepare("SELECT * FROM AccountTfaRecoverTokens WHERE accountID = ? AND expiryDate > ?");
			  $recoverRequest->execute(array(auth()->user()->id(), datetime()));
			  $recoverRequest = $recoverRequest->fetch();
			  
			  if ($recoverRequest) {
				  // Last try is less than 2 min ago
				  if ($recoverRequest["lastSend"] > date('Y-m-d H:i:s', strtotime('-2 minutes'))) {
					  return back()->flash('error', t__('Please wait a few minutes before trying again.'));
				  }
				  $token = $recoverRequest['token'];
				  $updateAccountTfaRecoverTokens = db()->prepare("UPDATE AccountTfaRecoverTokens SET lastSend = ? WHERE id = ?");
				  $updateAccountTfaRecoverTokens->execute(array(datetime(), $recoverRequest['id']));
			  } else {
				  $token = rand_token();
				  $insertAccountTfaRecoverTokens = db()->prepare("INSERT INTO AccountTfaRecoverTokens (accountID, token, creationIP, expiryDate, lastSend, creationDate) VALUES (?, ?, ?, ?, ?, ?)");
				  $insertAccountTfaRecoverTokens->execute(array(auth()->user()->id(), $token, getIP(), createDuration(0.04166666666), datetime(), datetime()));
			  }
				
				$url = website_url(url('tfa.recover.action', ['token' => $token]));
			  $search = array("%username%", "%url%");
			  $replace = array(auth()->user()->displayName(), $url);
			  $template = modules('tfa')->settings('tfaEmailTemplate');
			  $content = str_replace($search, $replace, $template);
				JobDispatcher::dispatch((new SendEmail(auth()->user()->email(), modules('tfa')->settings('tfaEmailTitle'), $content)));
				
			  return back()->flash('success', t__('A reset link has been sent to your email address!'));
		  } catch (Exception $e) {
			  return back()->flash('error', t__('Could not send mail due to a system error:')." ".$e->errorMessage());
		  }
	  }
	  
	  public function recover($token)
	  {
			// Check if the token exists
			$recoverRequest = db()->prepare("SELECT * FROM AccountTfaRecoverTokens WHERE accountID = ? AND token = ? AND expiryDate > ?");
		  $recoverRequest->execute([auth()->user()->id(), $token, datetime()]);
		  $recoverRequest = $recoverRequest->fetch();
			
			if (!$recoverRequest) abort_404();
			
			// Expire the token
      $expireToken = db()->prepare("UPDATE AccountTfaRecoverTokens SET expiryDate = ? WHERE id = ?");
			$expireToken->execute([datetime(), $recoverRequest['id']]);
			
			// Delete the TFA secret key
      $deleteSecretKey = db()->prepare("DELETE FROM AccountTfaKeys WHERE accountID = ?");
			$deleteSecretKey->execute([$recoverRequest['accountID']]);
		 
			// Mark the session as TFA verified by setting isTfaVerified to 1
		  $verifyTfa = db()->prepare("UPDATE AccountSessions SET isTfaVerified = ? WHERE loginToken = ?");
		  $verifyTfa->execute([1, session()->get('login')]);
			
		  // Redirect to the profile page
			$redirect = new Redirect(url('account.profile.index'));
		  return $redirect->flash('success', t__('Two Factor Authentication has been disabled.'));
	  }
  }