<?php
  
  namespace Main\Controllers\TFA;
  
  use Main\Core\Controller;
  use Main\Services\SeoService;
  use PDO;
  use RobThree\Auth\TwoFactorAuth;
  use RobThree\Auth\TwoFactorAuthException;
  
  class TfaController extends Controller
  {
	  protected string $route_type = 'tfa';
		private $secretKey;
		
	  public function __construct()
		{
			if (auth()->user()->isTfaRequired() !== true) {
				redirect(url('account.profile.index'));
			}
			
			$userSecretKey = db()->prepare("SELECT * FROM AccountTfaKeys WHERE accountID = ?");
			$userSecretKey->execute([auth()->user()->id()]);
			$userSecretKey = $userSecretKey->fetch();
			if (!$userSecretKey) abort_404();
			
			$this->secretKey = $userSecretKey['secretKey'];
		}
		
	  public function index()
    {
	    SeoService::set('tfa.index');
			
			session()->set('tfaRedirect', request()->getUrl()->getOriginalUrl());
			
	    return $this->view('tfa.verify');
    }
	  
	  /**
	   * @throws TwoFactorAuthException
	   */
	  public function verify()
	  {
			validate([
				'code' => 'required'
			]);
		  
		  if (recaptcha()->isEnabled('tfa') && !recaptcha()->verify()) {
			  return back()->flash('error', t__('Spam detected!'));
		  }
			
			$secretKey = $this->secretKey;
		  $code = input('code');
			
		  $tfa = new TwoFactorAuth(settings('serverName'));
			
			if ($tfa->verifyCode($secretKey, $code) !== true) {
				return back()->flash('error', t__('Wrong code!'));
			}
		  
		  // Mark the session as TFA verified by setting isTfaVerified to 1
		  $verifyTfa = db()->prepare("UPDATE AccountSessions SET isTfaVerified = ? WHERE loginToken = ?");
		  $verifyTfa->execute([1, session()->get('login')]);
			
			$redirectUrl = session()->get('tfaRedirect');
		  session()->remove('tfaRedirect');
			
			if (rtrim($redirectUrl, '/') == rtrim(url('tfa.index'), '/')) {
				$redirectUrl = url('account.profile.index');
			}
		  
		  redirect($redirectUrl);
	  }
  }