<?php
	namespace Main\Controllers\Tebex;
	
	use Curl\Curl;
	use Main\Core\Controller;
	use Main\Services\SeoService;
	use PDO;
	
	class StoreController extends Controller
	{
		protected string $route_type = 'store';
		
		public function index()
		{
			$tierTables = db()->query("SELECT * FROM VIPTables");
			$tierTables = array_map(function ($tierTable) {
				$tiers = db()->prepare("SELECT vipID FROM VIPs V WHERE V.tableID = ?");
				$tiers->execute(array($tierTable["id"]));
				$tierTable["tiers"] = $tiers->fetchAll(PDO::FETCH_COLUMN);
				
				$tierTitles = db()->prepare("SELECT * FROM VIPTitles WHERE tableID = ? ORDER BY priority ASC");
				$tierTitles->execute(array($tierTable["id"]));
				$tierTable["titles"] = array_map(function ($title) {
					$tierDescriptions = db()->prepare("SELECT D.description FROM VIPDesc D WHERE D.titleID = ?");
					$tierDescriptions->execute(array($title["id"]));
					$tierDescriptions = $tierDescriptions->fetchAll(PDO::FETCH_ASSOC);
					$title["descriptions"] = array_column($tierDescriptions, "description");
					
					$tierExplain = db()->prepare("SELECT name FROM VIPExplain WHERE titleID = ?");
					$tierExplain->execute(array($title["id"]));
					$tierExplain = $tierExplain->fetch(PDO::FETCH_ASSOC);
					$title["explain"] = ($tierExplain) ? $tierExplain["name"] : null;
					
					return $title;
				}, $tierTitles->fetchAll(PDO::FETCH_ASSOC));
				
				return $tierTable;
			}, $tierTables->fetchAll(PDO::FETCH_ASSOC));
			
			return $this->view('tebex.index', compact('tierTables'));
		}
		
		public function category($id)
		{
			$tierTables = db()->query("SELECT * FROM VIPTables");
			$tierTables = array_map(function ($tierTable) {
				$tiers = db()->prepare("SELECT vipID FROM VIPs V WHERE V.tableID = ?");
				$tiers->execute(array($tierTable["id"]));
				$tierTable["tiers"] = $tiers->fetchAll(PDO::FETCH_COLUMN);
				
				$tierTitles = db()->prepare("SELECT * FROM VIPTitles WHERE tableID = ? ORDER BY priority ASC");
				$tierTitles->execute(array($tierTable["id"]));
				$tierTable["titles"] = array_map(function ($title) {
					$tierDescriptions = db()->prepare("SELECT D.description FROM VIPDesc D WHERE D.titleID = ?");
					$tierDescriptions->execute(array($title["id"]));
					$tierDescriptions = $tierDescriptions->fetchAll(PDO::FETCH_ASSOC);
					$title["descriptions"] = array_column($tierDescriptions, "description");
					
					$tierExplain = db()->prepare("SELECT name FROM VIPExplain WHERE titleID = ?");
					$tierExplain->execute(array($title["id"]));
					$tierExplain = $tierExplain->fetch(PDO::FETCH_ASSOC);
					$title["explain"] = ($tierExplain) ? $tierExplain["name"] : null;
					
					return $title;
				}, $tierTitles->fetchAll(PDO::FETCH_ASSOC));
				
				return $tierTable;
			}, $tierTables->fetchAll(PDO::FETCH_ASSOC));
			
			return $this->view('tebex.index', [
				'category' => $id,
				'tierTables' => $tierTables
			]);
		}
		
		public function product($id)
		{
			return $this->view('tebex.product', [
				'product' => $id
			]);
		}
		
		public function cart()
		{
			return $this->view('tebex.cart');
		}
		
		public function login()
		{
			if (cookies()->has('tebexStoreBasketIdent')) {
				redirect(url('store.index'));
			}
			
			return $this->view('tebex.login');
		}
		
		public function order($id)
		{
			$order = db()->prepare("SELECT * FROM Orders WHERE id = ? AND accountID = ?");
			$order->execute([$id, auth()->user()->id()]);
			$order = $order->fetch(PDO::FETCH_ASSOC);
			
			if (!$order) abort_404();
			
			SeoService::set('orders.show', [
				'order_id' => $order['id'],
			]);
			
			$orderProducts = db()->prepare("SELECT P.name, OP.quantity, OP.unitPrice FROM OrderProducts OP INNER JOIN TebexProducts P ON OP.productID = P.id WHERE OP.orderID = ?");
			$orderProducts->execute([$id]);
			$order["products"] = $orderProducts->fetchAll(PDO::FETCH_ASSOC);
			
			return $this->view('orders.show', compact('order'));
		}
		
		public function authCallback()
		{
			$success = get('success');
			$basketIdent = get('basket');
			$package = get('package');
			
			if (!$success || !$basketIdent || $success != "true") {
				redirect(url('store.index'));
			}
			
			cookies()->set('tebexStoreBasketIdent', $basketIdent, 60 * 60 * 24 * 365);
			
			if ($package) {
				$addPackageRequest = new Curl();
				$addPackageRequest->setHeader('Content-Type', 'application/json');
				$addPackageRequest->post("https://headless.tebex.io/api/baskets/$basketIdent/packages", [
					'package_id' => $package
				]);
				
				redirect(url('cart.index'));
			}
			
			redirect(url('store.index'));
		}
	}