<?php
	
	namespace Main\Handlers;
	
	use Pecee\Http\Middleware\Exceptions\TokenMismatchException;
  use Pecee\Http\Request;
	use Pecee\SimpleRouter\Handlers\IExceptionHandler;
	
	class CsrfExceptionHandler implements IExceptionHandler
	{
		/**
		 * @param Request $request
		 * @param \Exception $error
		 * @throws \Exception
		 */
		public function handleError(Request $request, \Exception $error): void
		{
      if ($error instanceof TokenMismatchException) {
	      response()->httpCode(403);
				return;
      }
			
			throw $error;
		}
		
	}