<?php
	
	namespace Main\Handlers;
	
	use Pecee\Http\Request;
	use Pecee\SimpleRouter\Exceptions\NotFoundHttpException;
	use Pecee\SimpleRouter\Handlers\IExceptionHandler;
	
	class RouteExceptionHandler implements IExceptionHandler
	{
		/**
		 * @param Request $request
		 * @param \Exception $error
		 * @throws \Exception
		 */
		public function handleError(Request $request, \Exception $error): void
		{
			/* The router will throw the NotFoundHttpException on 404 */
			if ($error instanceof NotFoundHttpException) {
				
				/*
				 * Render your own custom 404-view, rewrite the request to another route,
				 * or simply return the $request object to ignore the error and continue on rendering the route.
				 *
				 * The code below will show 404 screen.
				 */
				response()->httpCode(404);
				$request->setRewriteUrl('/404');
				return;
			}
			
			throw $error;
			
		}
		
	}