<?php
	namespace Main\Jobs;
	
	use Main\Core\Jobs\Job;
	use Main\Services\DiscordBotService;
	
	class AddDiscordRoles extends Job
	{
		private $discordUserID;
		private $roles;
		
		public function __construct($discordUserID, $roles)
		{
			$this->discordUserID = $discordUserID;
			$this->roles = $roles;
			$this->maxAttempts = 3;
		}
		
		public function handle(): void
		{
			DiscordBotService::addRoles($this->discordUserID, $this->roles);
		}
	}