<?php
	namespace Main\Jobs;
	
	use Main\Core\Jobs\Job;
	use Main\Services\ParasutService;
	
	class CreateParasutInvoice extends Job
	{
		private $orderID;
		
		public function __construct($orderID)
		{
			$this->orderID = $orderID;
			$this->maxAttempts = 1;
		}
		
		public function handle(): void
		{
			ParasutService::createInvoice($this->orderID);
		}
	}