<?php
	namespace Main\Jobs;
	
	use Main\Core\Jobs\Job;
	use Main\Libs\Discord;
	
	class ResyncDiscordLegacy extends Job
	{
		private $discordUserID;
		
		public function __construct($accountDiscordID)
		{
			$this->discordUserID = $accountDiscordID;
			$this->maxAttempts = 3;
		}
		
		public function handle(): void
		{
			$discord = new Discord(
				modules('discord')->settings('clientID'),
				modules('discord')->settings('clientSecret'),
				modules('discord')->settings('botToken')
			);
			$discord->removeRole(
				modules('discord')->settings('guildID'),
				$this->discordUserID,
				modules('discord')->settings('syncedRoleID')
			);
			$discord->giveRole(
				modules('discord')->settings('guildID'),
				$this->discordUserID,
				modules('discord')->settings('syncedRoleID')
			);
		}
	}