<?php
	namespace Main\Jobs;
	
	use Main\Core\Jobs\Job;
	use Main\Services\CommandService;
	
	class SendCommand extends Job
	{
		private $ip;
		private $consolePort;
		private $consolePassword;
		private $consoleToken;
		private $consoleID;
		private $commands;
		
		public function __construct(
			$ip,
			$consolePort,
			$consolePassword,
			$consoleToken,
			$consoleID,
			$commands
		)
		{
			$this->ip = $ip;
			$this->consolePort = $consolePort;
			$this->consolePassword = $consolePassword;
			$this->consoleToken = $consoleToken;
			$this->consoleID = $consoleID;
			$this->commands = $commands;
		}
		
		public function handle(): void
		{
			CommandService::sendCommand(
				$this->ip,
				$this->consolePort,
				$this->consolePassword,
				$this->consoleToken,
				$this->consoleID,
				$this->commands
			);
		}
	}