<?php
	namespace Main\Jobs;
	
	use Main\Core\Jobs\Job;
	use Main\Services\DiscordWebhookService;
	
	class SendDiscordWebhook extends Job
	{
		private string $event;
		private array $variables;
		
		public function __construct(string $event, array $variables)
		{
			$this->event = $event;
			$this->variables = $variables;
			$this->maxAttempts = 3;
		}
		
		public function handle(): void
		{
			DiscordWebhookService::send($this->event, $this->variables);
		}
	}