<?php
	namespace Main\Jobs;
	
	use Main\Core\Jobs\Job;
	use Main\Services\EmailService;
	
	class SendEmail extends Job
	{
		private string $to;
		private string $subject;
		private string $message;
		
		public function __construct(string $to, string $subject, string $message)
		{
			$this->to = $to;
			$this->subject = $subject;
			$this->message = $message;
			$this->maxAttempts = 1;
		}
		
		public function handle(): void
		{
			EmailService::send($this->to, $this->subject, $this->message);
		}
	}