<?php
	
	namespace Main\Libs\Payment;
	
	class Order
	{
		public int $id;
		public string $type;
		public float $total, $subtotal, $discount, $tax, $gatewayFee, $credits, $paymentAmount;
		public string $currency;
		public ?string $coupon;
		public string $singleProductName;
		public array $products;
		
		public function __construct($id, $type, $total, $subtotal, $tax, $gatewayFee, $discount, $credits, $coupon, $products)
		{
			$this->id = $id;
			$this->type = $type;
			$this->total = $total;
			$this->subtotal = $subtotal;
			$this->tax = $tax;
			$this->gatewayFee = $gatewayFee;
			$this->discount = $discount;
			$this->credits = $credits;
			$this->coupon = $coupon;
			$this->products = $products;
			if ($this->type == "credit") {
				$this->singleProductName = $products[0]->name;
			} else {
				$this->singleProductName = "Order #{$this->id}";
			}
			$this->paymentAmount = $this->total - $this->credits;
		}
	}