<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Cryptomus\Api\Client;
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Cryptomus extends PaymentGateway
	{
		protected bool $isContactRequired = false;
		protected bool $isBrowserSideCallback = false;
		
		public function payment()
		{
			$payment = Client::payment($this->config["payment_api_key"], $this->config["merchant_id"]);
			$data = [
				'amount' => (string) $this->order->paymentAmount,
				'currency' => $this->currency,
				'order_id' => (string) $this->order->id,
				'url_return' => $this->getCancelUrl(),
				'url_callback' => $this->getCallbackUrl(),
				'url_success' => $this->getSuccessUrl(),
				'is_payment_multiple' => true,
			];
			
			$result = $payment->create($data);
			redirect($result["url"]);
		}
		
		public function callback(): SuccessfulPayment
		{
			$data = file_get_contents('php://input');
			$data = json_decode($data, true);
			$sign = $data['sign'];
			unset($data['sign']);
			$hash = md5(base64_encode(json_encode($data, JSON_UNESCAPED_UNICODE)) . $this->config["payment_api_key"]);
			
			if (hash_equals($hash, $sign)) {
				if ($data["is_final"] && ($data["status"] == "paid" || $data["status"] == "paid_over")) {
					$orderID = $data["order_id"];
					$paymentID = $data["uuid"];
					
					return new SuccessfulPayment($orderID, $paymentID);
				} else {
					throw new Exception("Payment not completed!");
				}
			} else {
				throw new Exception("Invalid sign!");
			}
		}
	}