<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Manual extends PaymentGateway
	{
		/**
		 * Start Payment Process
		 *
		 * @throws Exception
		 */
		public function payment()
		{
			redirect(url('payment.pay.manual', ['orderId' => $this->order->id]));
		}
		
		/**
		 * Handle Payment Callback
		 *
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if (post("apiKey") != settings('apiKey')) {
				throw new Exception("Invalid Request");
			}
			
			$orderID = post("orderID");
			$paymentID = post("paymentID");
			
			return new SuccessfulPayment($orderID, $paymentID);
		}
	}