<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Mercadopago extends PaymentGateway
	{
		public function payment()
		{
			\MercadoPago\SDK::setAccessToken($this->config["access_token"]); // Either Production or SandBox AccessToken
			
			$preference = new \MercadoPago\Preference();
			$preference->back_urls = array(
				"success" => $this->getSuccessUrl(),
				"failure" => $this->getCancelUrl(),
				"pending" => $this->getCancelUrl()
			);
			$preference->auto_return = "approved";
			$preference->external_reference = $this->order->id;
			$preference->notification_url = $this->getCallbackUrl() . "?source_news=ipn";
			
			$item = new \MercadoPago\Item();
			$item->title = $this->order->singleProductName;
			$item->quantity = 1;
			$item->unit_price = $this->order->paymentAmount;
			$item->currency_id = $this->currency;
			$preference->items = array($item);
			$preference->save();
			
			redirect($preference->init_point);
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			\MercadoPago\SDK::setAccessToken($this->config["access_token"]); // Either Production or SandBox AccessToken
			
			$merchant_order = null;
			
			switch (get("topic")) {
				case "payment":
					$payment = \MercadoPago\Payment::find_by_id(get("id"));
					// Get the payment and the corresponding merchant_order reported by the IPN.
					$merchant_order = \MercadoPago\MerchantOrder::find_by_id($payment->order->id);
					break;
				case "merchant_order":
					$merchant_order = \MercadoPago\MerchantOrder::find_by_id(get("id"));
					break;
			}
			
			if ($merchant_order == null)
				throw new Exception("Order not found!");
			
			// If the payment's transaction amount is equal (or bigger) than the merchant_order's amount you can release your items
			if ($merchant_order->order_status == 'paid') {
				$orderID = $merchant_order->external_reference;
				$paymentID = get("id");
				
				return new SuccessfulPayment($orderID, $paymentID);
			} else {
				throw new Exception("Not paid yet. Do not release your item!");
			}
		}
	}