<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Paybylink extends PaymentGateway
	{
		public function payment()
		{
			$rushPay = new RushPayMain('v1', intval($this->config["shop_id"]), $this->config["secret_key"], $this->config["hashing_algorithm"]);
			$request = new TransferGenerateRequest($this->order->paymentAmount);
			$request->setControl($this->order->id);
			$request->setEmail($this->customer->email);
			$request->setReturnUrlSuccess($this->getSuccessUrl());
			$request->setNotifyUrl($this->getCallbackUrl());
			$response = $rushPay->sendTransferGenerateRequest($request);
			
			redirect($response->getUrl());
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			$rushPay = new RushPayMain('v1', $this->config["shop_id"], $this->config["secret_key"], $this->config["hashing_algorithm"]);
			
			$response = file_get_contents('php://input');
			$response = $rushPay->getTransferNotification($response);
			
			if ($response == null) {
				throw new Exception("Invalid response");
			}
			
			$orderID = $response->control;
			$paymentID = $response->transactionId;
			
			return new SuccessfulPayment($orderID, $paymentID);
		}
	}