<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class PaypalLegacy extends PaymentGateway
	{
		/**
		 * Start Payment Process
		 *
		 * @throws Exception
		 */
		public function payment()
		{
			$paypalUrl = $this->config["sandbox"] ? 'https://www.sandbox.paypal.com/cgi-bin/webscr' : 'https://www.paypal.com/cgi-bin/webscr';
			$queryString = http_build_query([
				'cmd' => '_xclick',
				'no_rate' => '1',
				'bn' => 'PP-BuyNowBF:btn_buynow_LG.gif:NonHostedGuest',
				'business' => $this->config["email"],
				'return' => $this->getSuccessUrl(),
				'cancel_return' => $this->getCancelUrl(),
				'notify_url' => $this->getCallbackUrl(),
				'item_name' => $this->order->singleProductName,
				'amount' => $this->order->paymentAmount,
				'currency_code' => $this->currency,
				'custom' => $this->order->id,
			]);
			header('location:' . $paypalUrl . '?' . $queryString);
			exit();
		}
		
		/**
		 * Handle Payment Callback
		 *
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			$data = $_POST;
			$paypalUrl = $this->config["sandbox"] ? 'https://ipnpb.sandbox.paypal.com/cgi-bin/webscr' : 'https://ipnpb.paypal.com/cgi-bin/webscr';
			$req = 'cmd=_notify-validate';
			foreach ($data as $key => $value) {
				$value = urlencode(stripslashes($value));
				$value = preg_replace('/(.*[^%^0^D])(%0A)(.*)/i', '${1}%0D%0A${3}', $value); // IPN fix
				$req .= "&$key=$value";
			}
			
			$ch = curl_init($paypalUrl);
			curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
			curl_setopt($ch, CURLOPT_SSLVERSION, 6);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
			curl_setopt($ch, CURLOPT_FORBID_REUSE, 1);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
			curl_setopt($ch, CURLOPT_HTTPHEADER, array(
				'User-Agent: PHP-IPN-Verification-Script',
				'Connection: Close',
			));
			$res = curl_exec($ch);
			
			if (!$res) {
				$errno = curl_errno($ch);
				$errstr = curl_error($ch);
				curl_close($ch);
				throw new Exception("cURL error: [$errno] $errstr");
			}
			
			$info = curl_getinfo($ch);
			
			// Check the http response
			$httpCode = $info['http_code'];
			if ($httpCode != 200) {
				throw new Exception("PayPal responded with http code $httpCode");
			}
			curl_close($ch);
			
			$orderID = post("custom");
			$paymentID = post("txn_id");
			
			if (strcmp($res, "VERIFIED") == 0) {
				$paymentStatus = post("payment_status");
				$paymentAmount = post("mc_gross");
				$paymentCurrency = post("mc_currency");
				$receiverEmail = post("receiver_email");
				
				$order = db()->prepare("SELECT total FROM Orders WHERE status = ? AND id = ?");
				$order->execute(array(0, $orderID));
				$order = $order->fetch();
				if (!$order) {
					throw new Exception("Order not found");
				}
				if ($paymentStatus != "Completed") {
					throw new Exception("Payment status is not completed");
				}
				if ($receiverEmail != $this->config["email"]) {
					throw new Exception("Payment receiver email is not valid");
				}
				if ($paymentCurrency != $this->getCurrency()) {
					throw new Exception("Payment currency is not valid");
				}
				if ($paymentAmount != $order["total"]) {
					throw new Exception("Payment amount is not valid");
				}
				
				return new SuccessfulPayment($orderID, $paymentID);
			}
			else {
				throw new Exception("IPN Verification failed");
			}
		}
	}