<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Curl\Curl;
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Paytr extends PaymentGateway
	{
		protected bool $isContactRequired = true;
		
		/**
		 * @throws Exception
		 */
		public function payment()
		{
			$paymentAmount = $this->order->paymentAmount * 100;
			$noInstallment = 0;
			$maxInstallment = 0;
			$timeoutLimit = "30";
			$currency = "TL";
			$debugStatus = 0;
			$testModeStatus = 0;
			$products = base64_encode(json_encode(array(
				array(substr($this->order->singleProductName, 0, 50), $this->order->paymentAmount, 1),
			)));
			$paytrHash 	= $this->config["merchant_id"].$this->customer->ipAddress.$this->order->id.$this->customer->email.$paymentAmount.$products.$noInstallment.$maxInstallment.$currency.$testModeStatus;
			$paytrToken = base64_encode(hash_hmac('SHA256', $paytrHash.$this->config["merchant_salt"], $this->config["merchant_key"], true));
			$curlURL = 'https://www.paytr.com/odeme/api/get-token';
			$postFields = array(
				'merchant_id'				=> $this->config["merchant_id"],
				'merchant_oid' 			=> $this->order->id,
				'payment_amount'		=> $paymentAmount,
				'paytr_token'				=> $paytrToken,
				'user_basket'				=> $products,
				'no_installment'		=> $noInstallment,
				'max_installment'		=> $maxInstallment,
				'email'							=> $this->customer->email,
				'user_name'					=> $this->customer->contact->name ." ". $this->customer->contact->surname,
				'user_address'			=> "Esentepe Mahallesi Eski Büyükdere Caddesi, Tekfen Tower No:209, 34343 4.Levent/Şişli",
				'user_phone'				=> $this->customer->contact->phoneNumber,
				'user_ip' 					=> $this->customer->ipAddress,
				'merchant_ok_url'		=> $this->getSuccessUrl(),
				'merchant_fail_url'	=> $this->getCancelUrl(),
				'timeout_limit'			=> $timeoutLimit,
				'currency'					=> $currency,
				'debug_on'					=> $debugStatus,
				'test_mode'					=> $testModeStatus,
				'iframe_v2'         => $this->config["iframe_version"] == 'v2' ? 1 : 0,
				'iframe_v2_dark'    => ($this->config["iframe_version"] == 'v2' && $this->config["dark_theme"] == '1') ? 1 : 0,
			);
			
			$curl = new Curl();
			$curl->post($curlURL, $postFields);
			$response = json_decode($curl->response);
			if ($response->status == 'success') {
				redirect("https://www.paytr.com/odeme/guvenli/" . $response->token);
			}
			else {
				throw new Exception($response);
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if ($this->config["merchant_salt"] == "" || $this->config["merchant_salt"] == null || $this->config["merchant_key"] == "" || $this->config["merchant_key"] == null) {
				throw new Exception("Paytr API bilgileri eksik!");
			}
			
			if (isset($_POST["status"]) && isset($_POST["merchant_oid"]) && isset($_POST["total_amount"])) {
				$hash = base64_encode(hash_hmac('SHA256', post("merchant_oid").$this->config["merchant_salt"].post("status").post("total_amount"), $this->config["merchant_key"], true));
				if (post("hash") == $hash) {
					if (post("status") == "success") {
						$orderID = post("merchant_oid");
						$paymentID = (string) post("merchant_oid");
						
						return new SuccessfulPayment($orderID, $paymentID);
					}
					else {
						throw new Exception("Odeme basarisiz!");
					}
				}
				else {
					throw new Exception("Hash kontrolu basarisiz!");
				}
			}
			else {
				throw new Exception("POST verisi bulunamadi!");
			}
		}
	}