<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Curl\Curl;
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class PaytrEft extends PaymentGateway
	{
		protected bool $isContactRequired = true;
		
		/**
		 * @throws Exception
		 */
		public function payment()
		{
			$paymentAmount = $this->order->paymentAmount * 100;
			$timeoutLimit = "30";
			$debugStatus = 0;
			$testModeStatus = 0;
			$paymentType = "eft";
			$paytrHash 	= $this->config["merchant_id"].$this->customer->ipAddress.$this->order->id.$this->customer->email.$paymentAmount.$paymentType.$testModeStatus;
			$paytrToken = base64_encode(hash_hmac('SHA256', $paytrHash.$this->config["merchant_salt"], $this->config["merchant_key"], true));
			$curlURL = 'https://www.paytr.com/odeme/api/get-token';
			$postFields = array(
				'merchant_id'				=> $this->config["merchant_id"],
				'merchant_oid' 			=> $this->order->id,
				'payment_amount'		=> $paymentAmount,
				'payment_type'		  => $paymentType,
				'paytr_token'				=> $paytrToken,
				'email'							=> $this->customer->email,
				'user_ip' 					=> $this->customer->ipAddress,
				'timeout_limit'			=> $timeoutLimit,
				'debug_on'					=> $debugStatus,
				'test_mode'					=> $testModeStatus
			);
			
			$curl = new Curl();
			$curl->post($curlURL, $postFields);
			$response = json_decode($curl->response);
			if ($response->status == 'success') {
				redirect("https://www.paytr.com/odeme/api/" . $response->token);
			}
			else {
				throw new Exception($response);
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if ($this->config["merchant_salt"] == "" || $this->config["merchant_salt"] == null || $this->config["merchant_key"] == "" || $this->config["merchant_key"] == null) {
				throw new Exception("Paytr API bilgileri eksik!");
			}
			
			if (isset($_POST["status"]) && isset($_POST["merchant_oid"]) && isset($_POST["total_amount"])) {
				$hash = base64_encode(hash_hmac('SHA256', post("merchant_oid").$this->config["merchant_salt"].post("status").post("total_amount"), $this->config["merchant_key"], true));
				if (post("hash") == $hash) {
					if (post("status") == "success") {
						$orderID = post("merchant_oid");
						$paymentID = (string) post("merchant_oid");
						
						return new SuccessfulPayment($orderID, $paymentID);
					}
				}
				else {
					throw new Exception("Hash kontrolu basarisiz!");
				}
			}
			else {
				throw new Exception("POST verisi bulunamadi!");
			}
		}
	}