<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class PayuIndia extends PaymentGateway
	{
		protected bool $isBrowserSideCallback = true;
		
		public function payment()
		{
			$curlURL = 'https://secure.payu.in/_payment';
			$hashString = $this->config["merchant_key"]."|".$this->order->id."|".$this->order->paymentAmount."|".$this->order->singleProductName."|"."-"."|".$this->customer->email."|||||||||||".$this->config["merchant_salt"];
			$hash = hash('sha512', $hashString);
			$postFields = [
				"key" => $this->config["merchant_key"],
				"txnid" => $this->order->id,
				"amount" => $this->order->paymentAmount,
				"productinfo" => $this->order->singleProductName,
				"firstname" => "-",
				"email" => $this->customer->email,
				"phone" => "-",
				"surl" => $this->getCallbackUrl(),
				"furl" => $this->getCancelUrl(),
				"hash" => $hash,
			];
			echo '<html>';
			echo '<script>function load() { document.payuform.submit(); }</script>';
			echo '<body onload="load()">';
			echo '<h1>Redirecting...</h1>';
			echo '<p>Wait while we redirect to you</p>';
			echo '<form action="'.$curlURL.'" name="payuform" id="payuform" method="post">';
			foreach ($postFields as $key => $value) {
				echo '<input type="hidden" name="'.$key.'" value="'.$value.'">';
			}
			echo '</form>';
			echo '</body>';
			echo '</html>';
			exit();
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			$merchantKey = $this->config["merchant_key"];
			$merchantSalt = $this->config["merchant_salt"];
			$postedHash = post("hash");
			$reverseHash = hash("sha512", $merchantSalt . "|" . post("status") . "|||||||||||" . post("email") . "|" . post("firstname") . "|" . post("productinfo") . "|" . post("amount") . "|" . post("txnid") . "|" . $merchantKey);
			if ($postedHash == $reverseHash) {
				if (post("status") == "success") {
					$orderID = post("txnid");
					$paymentID = post("mihpayid");
					
					return new SuccessfulPayment($orderID, $paymentID);
				}
			} else {
				throw new Exception("Invalid hash");
			}
		}
	}