<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	use Paywant\Config;
	use Paywant\Model\Buyer;
	use Paywant\Model\PaymentChannel;
	use Paywant\Model\Product;
	use Paywant\Payment\Create;
	
	class Paywant extends PaymentGateway
	{
		protected bool $isContactRequired = true;
		
		/**
		 * @throws Exception
		 */
		public function payment()
		{
			$paywantConfig = new Config();
			$paywantConfig->setAPIKey($this->config['api_key']); // API KEY
			$paywantConfig->setSecretKey($this->config['secret_key']); // API SECRET
			$paywantConfig->setServiceBaseUrl('https://secure.paywant.com');
			
			// create request object with config
			$paywantRequest = new Create($paywantConfig);
			
			// set user ip
			$paywantRequest->setUserIPAddress(getIP());
			
			// create object for buyer info.
			$paywantBuyer = new Buyer();
			
			$paywantBuyer->setUserAccountName($this->customer->email); // if you don't have customers username, please use user email
			$paywantBuyer->setUserEmail($this->customer->email); // customer email address
			$paywantBuyer->setUserID($this->customer->id); // immutable customer id currently must be Integer
			
			$paywantProduct = new Product();
			$paywantProduct->setName($this->order->singleProductName);
			$paywantProduct->setAmount($this->order->paymentAmount);
			$paywantProduct->setExtraData($this->order->id); // You can use it for your own purpose. Note: Currently must be Integer
			
			$paywantPaymentChannels = new PaymentChannel();
			$paywantPaymentChannels->addPaymentChannel(PaymentChannel::ALL_CHANNELS);
			
			$paywantProduct->setPaymentChannel($paywantPaymentChannels);
			$paywantProduct->setCommissionType(Product::TAKE_ALL);
			
			// set objects to Request
			$paywantRequest->setBuyer($paywantBuyer);
			$paywantRequest->setProductData($paywantProduct);
			
			// set success info url after payment
			$paywantRequest->setRedirect_url($this->getSuccessUrl());
			
			if ($paywantRequest->execute()) { // execute request
				$response = json_decode($paywantRequest->getResponse());
				if ($response->status) {
					redirect($response->message);
				} else {
					throw new Exception($response);
				}
			} else {
				throw new Exception($paywantRequest->getError());
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			$apiKey = $this->config["api_key"]; // api key
			$apiSecret = $this->config["secret_key"]; // api secret key
			
			$transactionID = post('transactionID');
			$extraData = post('extraData');
			$userID = post('userID');
			$userAccountName = post('userAccountName');
			$paywantStatus = post('status');
			$paymentChannel = post('paymentChannel');
			$paymentTotal = post('paymentTotal');
			$netProfit = post('netProfit');
			$hash = $_POST['hash']; // don't touch. (not need xss-filter, anti sql injection filter etc.)
			
			$hashCheck = base64_encode(hash_hmac('sha256', "{$transactionID}|{$extraData}|{$userID}|{$userAccountName}|{$paywantStatus}|{$paymentChannel}|{$paymentTotal}|{$netProfit}" . $apiKey, $apiSecret, true));
			if ($hash == $hashCheck) {
				if ($paywantStatus == 100) {
					$orderID = $extraData;
					$paymentID = (string)$transactionID;
					
					return new SuccessfulPayment($orderID, $paymentID);
				} else {
					throw new Exception("Payment failed!");
				}
			} else {
				throw new Exception("Hash check failed!");
			}
		}
	}