<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Phonepe extends PaymentGateway
	{
		protected bool $isContactRequired = false;
		protected bool $isBrowserSideCallback = false;
		
		public function payment()
		{
			$phonepe = \PhonePe\PhonePe::init(
				$this->config["merchant_id"], // Merchant ID
				$this->customer->id, // Merchant User ID
				$this->config["api_key"], // Salt Key
				"1", // Salt Index
				$this->getSuccessUrl(), // Redirect URL, can be defined on per transaction basis
				$this->getCallbackUrl(), // Callback URL, can be defined on per transaction basis
				"PROD", // or "PROD",
				"POST"
			);
			
			
			$amountInPaisa = $this->order->paymentAmount * 100; // Amount in Paisa
			$userMobile = "9999999999"; // User Mobile Number
			$transactionID = $this->order->id; // Transaction ID to track and identify the transaction, make sure to save this in your database.
			
			$redirectURL = $phonepe->standardCheckout()->createTransaction($amountInPaisa, $userMobile, $transactionID)->getTransactionURL();
			redirect($redirectURL);
		}
		
		public function callback(): SuccessfulPayment
		{
			$phonepe = \PhonePe\PhonePe::init(
				$this->config["merchant_id"], // Merchant ID
				0, // Merchant User ID
				$this->config["api_key"], // Salt Key
				"1", // Salt Index
				"", // Redirect URL, can be defined on per transaction basis
				"", // Callback URL, can be defined on per transaction basis
				"PROD" // or "PROD"
			);
			
			$phonepeResponse = $phonepe->standardCheckout()->getTransactionResponse();
			if ($phonepe->standardCheckout()->isTransactionSuccess()) {
				$orderID = $phonepeResponse['data']['merchantTransactionId'];
				$paymentID = $phonepe->standardCheckout()->getTransactionID();
				return new SuccessfulPayment($orderID, $paymentID);
			} else {
				throw new Exception("Invalid sign!");
			}
		}
	}