<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Curl\Curl;
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Shipy extends PaymentGateway
	{
		protected bool $isContactRequired = true;
		
		public function payment()
		{
			$curl = new Curl();
			$curl->post("https://api.shipy.dev/pay/credit_card", [
				'usrIp'       => $this->customer->ipAddress,
				'usrEmail'    => $this->customer->email,
				'usrName'     => $this->customer->contact->name.' '.$this->customer->contact->surname,
				'usrAddress'  => 'Esentepe Mahallesi Eski Büyükdere Caddesi, Tekfen Tower No:209, 34343 4.Levent/Şişli',
				'usrPhone'    => $this->customer->contact->phoneNumber,
				'apiKey'      => $this->config["api_key"],
				'amount'      => $this->order->paymentAmount,
				'returnID'    => $this->order->id,
				'currency'    => $this->currency,
				'pageLang'    => $this->lang == "tr" ? 'TR' : 'EN',
				'mailLang'    => $this->lang == "tr" ? 'TR' : 'EN',
				'installment' => 0
			]);
			$response = json_decode($curl->response);
			if ($response->status == 'success') {
				redirect($response->link);
			}
			else {
				throw new Exception($response);
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if (empty($this->config["api_key"])) {
				throw new Exception("Geçersiz İstek!");
			}
			
			$allowedIps = json_decode(file_get_contents('https://shipy.net/security/whitelist'), true);
			if (in_array(getIP(), $allowedIps)) {
				$hashtr = post("paymentID").post("returnID").post("paymentType").post("paymentAmount").post("paymentCurrency").$this->config["api_key"];
				$hashbytes = mb_convert_encoding($hashtr, "ISO-8859-9");
				$hash = base64_encode(sha1($hashbytes, true));
				if (post("paymentHash") == $hash) {
					$orderID = post("returnID");
					$paymentID = (string)post("paymentID");
					
					return new SuccessfulPayment($orderID, $paymentID);
				}
				else {
					throw new Exception("Hash kontrolü başarısız!");
				}
			}
			else {
				throw new Exception("Geçersiz IP Adresi!");
			}
		}
	}