<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	use Stripe\Checkout\Session;
	use Stripe\Coupon;
	use Stripe\Webhook;
	
	class Stripe extends PaymentGateway
	{
		/**
		 * Start Payment Process
		 *
		 * @throws Exception
		 */
		public function payment()
		{
			\Stripe\Stripe::setApiKey($this->config["secret_key"]);
			header('Content-Type: application/json');
			
			$checkout_session = Session::create([
				'line_items' => [
					[
						'price_data' => [
							'currency' => $this->currency,
							'product_data' => [
								'name' => $this->order->singleProductName,
							],
							'unit_amount' => $this->order->paymentAmount * 100
						],
						'quantity' => 1,
					]
				],
				'metadata' => [
					'data' => $this->order->id,
				],
				'discounts' => [],
				'mode' => 'payment',
				'success_url' => $this->getSuccessUrl(),
				'cancel_url' => $this->getCancelUrl(),
			]);
			
			header("HTTP/1.1 303 See Other");
			header("Location: " . $checkout_session->url);
		}
		
		/**
		 * Handle Payment Callback
		 *
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
// This is your Stripe CLI webhook secret for testing your endpoint locally.
			$endpoint_secret = $this->config["webhook_key"];
			
			$payload = @file_get_contents('php://input');
			$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
			
			try {
				$event = Webhook::constructEvent(
					$payload, $sig_header, $endpoint_secret
				);
			} catch(\UnexpectedValueException $e) {
				// Invalid payload
				http_response_code(400);
				throw new Exception('Invalid payload');
			} catch(\Stripe\Exception\SignatureVerificationException $e) {
				// Invalid signature
				http_response_code(400);
				throw new Exception('Invalid signature');
			}
			
			// Handle the event
			switch ($event->type) {
				//case 'charge.failed':
				//  http_response_code(200);
				//  exit();
				case 'checkout.session.completed':
					$checkout = $event->data->object;
					$orderID = $checkout->metadata->data;
					$paymentID = (string) $checkout->payment_intent;
					
					return new SuccessfulPayment($orderID, $paymentID);
				default:
					throw new Exception('Received unknown event type ' . $event->type);
			}
		}
	}