<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Curl\Curl;
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Upigateway extends PaymentGateway
	{
		protected bool $isBrowserSideCallback = true;
		
		/**
		 * @throws Exception
		 */
		public function payment()
		{
			$postFields = array(
				"token" => $this->config["token"],
				"order_id" => $this->order->id,
				"txn_amount" => strval(intval($this->order->paymentAmount)),
				"txn_note" => $this->order->singleProductName,
				"product_name" => $this->order->singleProductName,
				"customer_name" => $this->customer->username,
				"customer_mobile" => "9000000000", //$this->customer->contact->phoneNumber
				"customer_email" => $this->customer->email,
				"callback_url" => $this->getCallbackUrl()
			);
			$curlURL = 'https://pg.onlinesahyog.com/order/create';
			$curl = new Curl();
			$curl->setHeader('Content-Type', 'application/json');
			$curl->post($curlURL, $postFields);
			$response = $curl->response;
			if ($response->status) {
				redirect($response->results->payment_url);
			} else {
				throw new Exception("Payment failed");
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if (post("order_id")) {
				$postFields = [
					"token" => $this->config["token"],
					"order_id" => post("order_id"),
				];
				$curlURL = "https://pg.onlinesahyog.com/order/status";
				$curl = new Curl();
				$curl->setHeader('Content-Type', 'application/json');
				$curl->post($curlURL, $postFields);
				$response = $curl->response;
				if ($response->results->status == "Success") {
					$orderID = $response->results->order_id;
					$paymentID = (string)$response->results->txn_id;
					
					return new SuccessfulPayment($orderID, $paymentID);
				} else {
					throw new Exception("Payment failed");
				}
			} else {
				throw new Exception("Order ID not found");
			}
		}
	}