<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	use Main\Libs\ValletAPI;
	
	class Vallet extends PaymentGateway
	{
		protected bool $isContactRequired = true;
		
		/**
		 * @throws Exception
		 */
		public function payment()
		{
			$vallet = new ValletAPI($this->config["username"], $this->config["password"], $this->config["store_code"], $this->config["hash"]);
			$order_data = array(
				'productName' => $this->order->singleProductName,
				'productData' => array(
					array(
						'productName'=> $this->order->singleProductName,
						'productPrice'=> $this->order->paymentAmount,
						'productType'=> 'DIJITAL_URUN',
					),
				),
				'productType' => 'DIJITAL_URUN',
				'productsTotalPrice' => $this->order->paymentAmount,
				'orderPrice' => $this->order->paymentAmount,
				'currency' => 'TRY',
				'orderId' => 'PM-'.rand(100000, 999999),
				'locale' => 'tr',
				'conversationId' => $this->order->id,
				'buyerName' => $this->customer->contact->name,
				'buyerSurName' => $this->customer->contact->surname,
				'buyerGsmNo' => $this->customer->contact->phoneNumber,
				'buyerIp' => $this->customer->ipAddress,
				'buyerMail' => $this->customer->email,
				'buyerAdress' => '',
				'buyerCountry' => '',
				'buyerCity' => '',
				'buyerDistrict' => '',
				'callbackOkUrl' => $this->getSuccessUrl(),
				'callbackFailUrl' => $this->getCancelUrl(),
			);
			$request = $vallet->create_payment_link($order_data);
			
			if ($request['status']=='success' && isset($request['payment_page_url'])) {
				redirect($request['payment_page_url']);
			}
			else {
				throw new Exception($request['message']);
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if (isset($_POST['status']) && isset($_POST['paymentStatus']) && isset($_POST['hash']) && isset($_POST['paymentCurrency']) && isset($_POST['paymentAmount']) && isset($_POST['paymentType']) && isset($_POST['orderId']) && isset($_POST['shopCode']) && isset($_POST['orderPrice']) && isset($_POST['productsTotalPrice']) && isset($_POST['productType']) && isset($_POST['callbackOkUrl']) && isset($_POST['callbackFailUrl'])) {
				$hash_string = post("orderId").post("paymentCurrency").post("orderPrice").post("productsTotalPrice").post("productType").$this->config["store_code"].$this->config["hash"];
				$MY_HASH = base64_encode(pack('H*', sha1($hash_string)));
				if ($MY_HASH === post("hash")) {
					if (post("paymentStatus") == 'paymentOk') {
						$orderID = post("conversationId");
						$paymentID = (string)post("orderId");
						
						return new SuccessfulPayment($orderID, $paymentID);
					}
					else {
						throw new Exception("Payment failed!");
					}
				}
				else {
					throw new Exception("Hash is not valid!");
				}
			}
			else {
				throw new Exception("Invalid Request!");
			}
		}
	}