<?php
	namespace Main\Libs\Payment\PaymentGateways;
	
	use Exception;
	use Main\Libs\Payment\PaymentGateway;
	use Main\Libs\Payment\SuccessfulPayment;
	
	class Weepay extends PaymentGateway
	{
		protected bool $isContactRequired = true;
		protected bool $isBrowserSideCallback = true;
		
		/**
		 * @throws Exception
		 */
		public function payment()
		{
			// Auth
			$options = new \weepay\Auth();
			$options->setBayiID($this->config["merchant_id"]);
			$options->setApiKey($this->config["api_key"]);
			$options->setSecretKey($this->config["secret_key"]);
			$options->setBaseUrl("https://api.weepay.co");
			
			//Request
			$request = new \weepay\Request\FormInitializeRequest();
			$request->setOrderId($this->order->id);
			$request->setIpAddress($this->customer->ipAddress);
			$request->setPrice($this->order->paymentAmount);
			$request->setCurrency(\weepay\Model\Currency::TL);
			$request->setLocale(\weepay\Model\Locale::TR);
			$request->setDescription(substr($this->order->singleProductName, 0, 50));
			$request->setCallBackUrl($this->getCallbackUrl());
			$request->setPaymentGroup(\weepay\Model\PaymentGroup::PRODUCT);
			$request->setPaymentChannel(\weepay\Model\PaymentChannel::WEB);
			
			//Customer
			$customer = new \weepay\Model\Customer();
			$customer->setCustomerId($this->customer->id); // Üye işyeri müşteri Id
			$customer->setCustomerName($this->customer->contact->name); //Üye işyeri müşteri ismi
			$customer->setCustomerSurname($this->customer->contact->surname); //Üye işyeri müşteri Soyisim
			$customer->setGsmNumber($this->customer->contact->phoneNumber); //Üye işyeri müşteri Cep Tel
			$customer->setEmail($this->customer->email); //Üye işyeri müşteri ismi
			$customer->setIdentityNumber("11111111111"); //Üye işyeri müşteri TC numarası
			$customer->setCity("İstanbul"); //Üye işyeri müşteri il
			$customer->setCountry("Türkiye");//Üye işyeri müşteri ülke
			$request->setCustomer($customer);
			
			//Adresler
			// Fatura Adresi
			$BillingAddress = new \weepay\Model\Address();
			$BillingAddress->setContactName($this->customer->contact->name." ".$this->customer->contact->surname);
			$BillingAddress->setAddress("Esentepe Mahallesi Eski Büyükdere Caddesi, Tekfen Tower No:209, 34343 4.Levent/Şişli");
			$BillingAddress->setCity("İstanbul");
			$BillingAddress->setCountry("Türkiye");
			$BillingAddress->setZipCode("34343");
			$request->setBillingAddress($BillingAddress);
			
			// Sipariş Ürünleri
			$Products = array();
			
			// Birinci Ürün
			$product = new \weepay\Model\Product();
			$product->setName($this->order->singleProductName);
			$product->setProductId($this->order->id);
			$product->setProductPrice($this->order->paymentAmount);
			$product->setItemType(\weepay\Model\ProductType::VIRTUAL);
			$Products[0] = $product;
			$request->setProducts($Products);
			
			$checkoutFormInitialize = \weepay\Model\CheckoutFormInitialize::create($request, $options);
			if ($checkoutFormInitialize->getStatus() == 'success') {
				redirect($checkoutFormInitialize->getPaymentPageUrl());
			}
			else {
				throw new Exception($checkoutFormInitialize->getMessage());
			}
		}
		
		/**
		 * @throws Exception
		 */
		public function callback(): SuccessfulPayment
		{
			if (isset($_POST["paymentStatus"]) && isset($_POST["paymentId"])) {
				if (post("paymentStatus")) {
					$request = new \weepay\Request\GetPaymentRequest();
					$request->setPaymentId(post("paymentId"));
					$request->setLocale(\weepay\Model\Locale::TR);
					
					$options = new \weepay\Auth();
					$options->setBayiID($this->config["merchant_id"]);
					$options->setApiKey($this->config["api_key"]);
					$options->setSecretKey($this->config["secret_key"]);
					$options->setBaseUrl("https://api.weepay.co");
					
					$getPaymentRequest = \weepay\Model\GetPaymentRequestInitialize::create($request, $options);
					if ($getPaymentRequest->getStatus() == 'success' && $getPaymentRequest->getPaymentStatus() == 'SUCCESS') {
						$orderID = post("orderId");
						$paymentID = (string)post("paymentId");
						
						return new SuccessfulPayment($orderID, $paymentID);
					}
					else {
						throw new Exception("Payment failed!");
					}
				}
				else {
					throw new Exception("Payment failed!");
				}
			}
			else {
				throw new Exception("Invalid Request!");
			}
		}
	}