<?php
	namespace Main\Libs\Translate;
	abstract class Generator {
		public static function read($type = null, $file = null, $themeFile = null, $customArray = []) {
			if ($type === 'php') {
				return include_once $file;
			}
			if ($type === 'json') {
        $text = json_decode(file_get_contents($file), true);
        $themeText = ($themeFile !== null) ? json_decode(file_get_contents($themeFile), true) : [];
				
				return array_merge($text, $themeText, $customArray);
			}
			if ($type === 'ini') {
				return parse_ini_file($file);
			}
			return false;
		}
	}
