<?php
	namespace Main\Middlewares;
	
  use Main\Core\Auth;
  use Main\Services\AvatarService;
  use Main\Services\DiscordBotService;
  use Main\Services\UserService;
  use PDO;
  use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class AuthMiddleware implements IMiddleware {
		
		public function handle(Request $request): void
		{
			global $readAccount;
			
			$needLogout = false;
			
			if (cookies()->has('rememberMe') || session()->has('login')) {
				$loginToken = ((cookies()->has('rememberMe')) ? cookies()->get('rememberMe') : ((session()->has('login')) ? session()->get('login') : null));
				$accountSearch = db()->prepare("SELECT A.*, ASe.loginToken, ASe.isTfaVerified FROM Accounts A INNER JOIN AccountSessions ASe ON A.id = ASe.accountID WHERE ASe.loginToken = ? AND ASe.expiryDate > ?");
				$accountSearch->execute(array($loginToken, datetime()));
				$readAccount = $accountSearch->fetch();
				if ($accountSearch->rowCount() > 0) {
					unset($readAccount["password"]);
					
					$siteBannedStatus = db()->prepare("SELECT id FROM BannedAccounts WHERE accountID = ? AND categoryID = ? AND (expiryDate > ? OR expiryDate = ?)");
					$siteBannedStatus->execute(array($readAccount["id"], 1, datetime(), '1000-01-01 00:00:00'));
					if ($siteBannedStatus->rowCount() == 0) {
						$readAccount["permissions"] = UserService::getPermissions($readAccount["id"]);
						$readAccount["roles"] = UserService::getRoles($readAccount["id"]);
						
						$readAccount["discordUserID"] = null;
						
						if (settings('loginProvider') == 'discord') {
							$readAccount["discordUserID"] = $readAccount["username"];
						} else if (DiscordBotService::isBotReady()) {
							$linkedAccount = db()->prepare("SELECT L.identifier FROM LinkedAccounts L INNER JOIN AccountLinkingProviders P ON P.id = L.providerID WHERE L.accountID = ? AND P.slug = ?");
							$linkedAccount->execute([$readAccount["id"], 'discord']);
							$linkedAccount = $linkedAccount->fetch(PDO::FETCH_ASSOC);
							if ($linkedAccount) {
								$readAccount["discordUserID"] = $linkedAccount["identifier"];
							}
						} else if (modules('discord')->isActive()) {
							// Legacy Discord Bot
							$accountDiscordData = db()->prepare("SELECT * FROM AccountDiscordData WHERE accountID = ?");
							$accountDiscordData->execute(array($readAccount["id"]));
							if ($accountDiscordData->rowCount() > 0) {
								$readAccountDiscordData = $accountDiscordData->fetch();
								$readAccount["discordUserID"] = $readAccountDiscordData["discordUserID"];
							}
						}
						
						// Get Avatar
						$readAccount["avatar"] = AvatarService::get($readAccount["id"], $readAccount["realname"]);
						
						session()->set('user', $readAccount);
						session()->set('login', $readAccount["loginToken"]);
						
						if (!cookies()->has('rememberMe')) {
							$updateAccountsSessions = db()->prepare("UPDATE AccountSessions SET expiryDate = ? WHERE accountID = ? AND loginToken = ?");
							$updateAccountsSessions->execute(array(createDuration(0.01666666666), $readAccount["id"], $loginToken));
						}
						$onlineAccountsHistory = db()->prepare("SELECT * FROM OnlineAccountsHistory WHERE accountID = ?");
						$onlineAccountsHistory->execute(array($readAccount["id"]));
						if ($onlineAccountsHistory->rowCount() > 0) {
							$updateOnlineAccountsHistory = db()->prepare("UPDATE OnlineAccountsHistory SET expiryDate = ?, creationDate = ? WHERE accountID = ?");
							$updateOnlineAccountsHistory->execute(array(createDuration(0.00347222222), datetime(), $readAccount["id"]));
						}
						else {
							$insertOnlineAccountsHistory = db()->prepare("INSERT INTO OnlineAccountsHistory (accountID, type, expiryDate, creationDate) VALUES (?, ?, ?, ?)");
							$insertOnlineAccountsHistory->execute(array($readAccount["id"], (auth()->user()->isStaff() ? 1 : 0), createDuration(0.00347222222), datetime()));
						}
					}
					else {
						$needLogout = true;
					}
				}
				else {
					$needLogout = true;
				}
			}
			
			if ($needLogout) {
				Auth::logout();
			}
			
			// TODO: Move to EmailNullCheckMiddleware
			if (auth()->check() && (auth()->user()->email() == null || auth()->user()->email() == "" || auth()->user()->email() == "your@email.com")) {
				request()->setRewriteUrl(url('auth.email'));
			}
		}
	}