<?php
	namespace Main\Middlewares;
	
	use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class CartMiddleware implements IMiddleware {
		public function handle(Request $request): void
		{
			$cartItemCount = 0;
			if (auth()->check() && modules('store')->isActive() && !modules('tebex_store')->isActive()) {
				$cartItemCount = db()->prepare("SELECT SC.accountID FROM ShoppingCartProducts SCP INNER JOIN Products P ON P.id = SCP.productID INNER JOIN ShoppingCarts SC ON SC.accountID = SCP.shoppingCartID WHERE SC.accountID = ?");
				$cartItemCount->execute(array(auth()->user()->id()));
				$cartItemCount = $cartItemCount->rowCount();
			}
			
			template()->addData(compact(
				'cartItemCount'
			));
		}
	}