<?php
	namespace Main\Middlewares;
	
	use PDO;
	use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class CurrencyMiddleware implements IMiddleware {
		public function handle(Request $request): void
		{
			global $currency, $currencies;
			
			$currencyInput = $request->getInputHandler()->get('currency');
			
			if ($currencyInput) {
				$currency = escape(strip_tags(trim($request->getInputHandler()->get('currency')->getValue())));
			} else {
				if (cookies()->has('currency')) {
					$currency = cookies()->get('currency');
				} else {
					$currency = settings('currency');
				}
			}
			
			$currencies = db()->prepare("SELECT * FROM Currencies WHERE code = ? AND isActive = '1'");
			$currencies->execute(array($currency));
			$currency = $currencies->fetch(PDO::FETCH_ASSOC);
			if ($currencies->rowCount() == 0) {
				if (cookies()->has('currency')) {
					cookies()->remove('currency');
				}
				
				$currencies = db()->prepare("SELECT * FROM Currencies WHERE code = ?");
				$currencies->execute(array(settings('currency')));
				$currency = $currencies->fetch(PDO::FETCH_ASSOC);
			}
			
			// Set currency to cookie
			// Check if currency is different from the default currency
			if ($currencyInput && $currency && $currency["code"] != settings('currency')) {
				cookies()->set('currency', $currency["code"], 365 * 24 * 60 * 60);
			}
			
			// Remove cookie if currency is the same as the default currency
			if ($currency && $currency["code"] == settings('currency')) {
				if (cookies()->has('currency')) {
					cookies()->remove('currency');
				}
			}
			
			// Available Currencies
			$currencies = db()->query("SELECT * FROM Currencies WHERE isActive = '1'");
			$currencies = $currencies->fetchAll(PDO::FETCH_ASSOC);
			
			// Add data to the template
			template()->addData(compact(
				'currencies',
				'currency',
			));
		}
	}