<?php
	namespace Main\Middlewares;
	
	use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class EmailVerificationMiddleware implements IMiddleware {
		
		public function handle(Request $request): void
		{
			// pass if user is not logged in or email verification is disabled
			if (!auth()->check() || !modules("email_verification")->isActive()) {
				return;
			}
			
			$whitelist = [
				url('email.verification.index'),
				url('email.verification.send'),
				url('email.verification.send-again'),
				url('email.verification.verify'),
				url('account.profile.index'),
				url('account.settings.profile'),
				url('account.settings.profile.update-details'),
				url('account.settings.security'),
				url('account.settings.security.change-email'),
				url('account.settings.security.change-password'),
				url('auth.logout'),
			];
			if (in_array($request->getUrl()->getPath(), $whitelist)) {
				return;
			}
			
			// if email verification is enabled and user is not verified, show email verification screen
			if (!auth()->user()->isEmailVerified()) {
				// Rewrite request to EmailVerificationController
				$request->setRewriteCallback('EmailVerificationController@index');
			}
		}
	}