<?php
	namespace Main\Middlewares;
	
	use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class MaintenanceMiddleware implements IMiddleware {
		
		public function handle(Request $request): void
		{
			$whitelist = array_map(function($el) {
				return rtrim($el, '/');
			}, [
				url('auth.login'),
				url('discord.login'),
				url('tebex.webhook'),
				url('robots-txt'),
				url('sitemap.index'),
			]);
			if (in_array(rtrim($request->getUrl()->getPath(), '/'), $whitelist)) {
				return;
			}
			
			// Sitemap Whitelist
			if (strpos($request->getUrl()->getPath(), '/sitemaps/') === 0) {
				return;
			}
			
			// Payment Callback Whitelist
			if (
				strpos($request->getUrl()->getPath(), '/payment/callback/') === 0 ||
				strpos($request->getUrl()->getPath(), '/callback/') === 0 ||
				strpos($request->getUrl()->getPath(), '/islem/') === 0
			) {
				return;
			}
			
			// Linked Accounts Login Whitelist
			if (strpos($request->getUrl()->getPath(), '/login-with/') === 0) {
				return;
			}
			
			
			// if Maintenance is enabled and user is not staff, show maintenance screen
			if (settings('maintenanceStatus') == 1 && (!auth()->check() || !auth()->user()->isStaff())) {
				// Return 503 Service Unavailable for search engines
				response()->httpCode(503);
				
				// Rewrite request to MaintenanceController
				$request->setRewriteCallback('MaintenanceController@index');
			}
		}
	}