<?php
	namespace Main\Middlewares;
	
	use PDO;
	use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class RedirectMiddleware implements IMiddleware {
		
		public function handle(Request $request): void
		{
			// if Maintenance is enabled and user is not staff, show maintenance screen
			$redirects = db()->query("SELECT * FROM UrlRedirects");
			$redirects = $redirects->fetchAll(PDO::FETCH_ASSOC);
			
			// Get the current url without the trailing slash
			$requestUrl = $request->getUrl();
			if (substr($requestUrl, -1) == '/') {
				$requestUrl = substr($requestUrl, 0, -1);
			}
			
			// Check if the current url is in the redirects
			foreach ($redirects as $redirect) {
				$redirectFrom = $redirect["from"];
				if (substr($redirectFrom, -1) == '/') {
					$redirectFrom = substr($redirectFrom, 0, -1);
				}
				
				if ($requestUrl == $redirectFrom) {
					// Set 302 code for search engines
					response()->httpCode(302);
					
					// Redirect to the target url
					redirect($redirect["to"]);
				}
			}
		}
	}