<?php
	namespace Main\Middlewares;
	
  use Pecee\Http\Middleware\IMiddleware;
	use Pecee\Http\Request;
	
	class TfaMiddleware implements IMiddleware {
		
		public function handle(Request $request): void
		{
			$whitelist = [
				rtrim(url('auth.logout'), '/'),
				rtrim(url('tfa.index'), '/'),
				rtrim(url('tfa.setup.index'), '/'),
				rtrim(url('tfa.recover.index'), '/'),
				rtrim(url('tfa.recover.action'), '/'),
			];
			if (auth()->check() && auth()->user()->isTfaRequired() && !in_array(rtrim($request->getUrl()->getOriginalUrl(), '/'), $whitelist)) {
				$request->setRewriteUrl(url('tfa.index'));
			}
		}
	}