<?php
	
	namespace Main\Services;
	
	use PDO;
	
	class AccountLinkingService
	{
		public static function getProviders()
		{
			if (!modules('account_linking')->isActive()) return [];
			
			$accountLinkingProviders = db()->prepare("SELECT * FROM AccountLinkingProviders WHERE isEnabled = ? AND slug != ?");
			$accountLinkingProviders->execute([1, settings('loginProvider')]);
			return array_map(function ($provider) {
				$provider['icon'] = '/assets/core/images/auth-providers/' . ($provider['slug'] == 'ingame' ? 'minecraft_ingame' : $provider['slug']) . '.svg';
				
				return $provider;
			}, $accountLinkingProviders->fetchAll(PDO::FETCH_ASSOC));
		}
	}