<?php
	namespace Main\Services;
	
	class CategoryService
	{
		public static function getCategoryPath($id, $tree = null, $path = [])
		{
			if ($tree === null) {
				$tree = json_decode(cache()->get('category_tree', '[]'), true);
			}
			
			foreach ($tree as $node) {
				$result = self::findCategoryRecursively($id, $node, $path);
				if ($result !== null) {
					return $result;
				}
			}
			
			return null;
		}
		
		private static function findCategoryRecursively($id, $node, $path = [])
		{
			if ($node['id'] == $id) {
				$path[] = $node['name'];
				return $path;
			}
			
			// Check if the current tree has subcategories
			if (isset($node['subcategories']) && is_array($node['subcategories']) && count($node['subcategories']) > 0) {
				$path[] = $node['name'];
				foreach ($node['subcategories'] as $subcategory) {
					$result = self::findCategoryRecursively($id, $subcategory, $path);
					if ($result !== null) {
						return $result;
					}
				}
				// Clean up the path
				array_pop($path);
			}
			
			return null;
		}
	}