<?php
	
	namespace Main\Services;
	
	use Exception;
	
	class CkEditorImageUploadService
	{
		/**
		 * @throws Exception
		 */
		public static function upload($file, $upload_dir): string
		{
			$imageID = rand_token();
			$image = new \Bulletproof\Image($file);
			$image->setStorage(__ROOT__ . $upload_dir);
			$image->setMime(array('png', 'jpg', 'jpeg', 'gif'));
			$image->setSize(10, 2 * 1000000); // 2 MB
			$image->setName($imageID);
			
			$upload = $image->upload();
			if ($upload) {
				return $image->getName() . '.' . $image->getMime();
			}
			
			throw new Exception($image->getError());
		}
	}