<?php
	namespace Main\Services;
	
	use Main\Core\Jobs\JobDispatcher;
	use Main\Jobs\AddDiscordRoles;
	use Main\Jobs\ResyncDiscordLegacy;
	use Main\Jobs\SendCommand;
	use PDO;
	
	class DeliveryService
	{
		public static function deliver($products, $accountID, $dataType, $dataID)
		{
			// Check Account
			$account = db()->prepare("SELECT * FROM Accounts WHERE id = ?");
			$account->execute(array($accountID));
			$readAccount = $account->fetch();
			if ($account->rowCount() == 0) exit;

			// Role and Subscription
			$discordRoles = [];
			foreach ($products as $product) {
				$getProduct = db()->prepare("SELECT P.*, C.isCumulative FROM Products P INNER JOIN ProductCategories C ON P.categoryID = C.id WHERE P.id = ?");
				$getProduct->execute(array($product["id"]));
				$readProduct = $getProduct->fetch();
				
				if ($getProduct->rowCount() > 0) {
					// Give Roles
					if ($readProduct["giveRoleID"] != 0) {
						for ($i = 0; $i < $product["quantity"]; $i++) {
							$roles = explode(',', $readProduct["giveRoleID"]);
							foreach ($roles as $role) {
								$checkRole = db()->prepare("SELECT * FROM Roles WHERE id = ?");
								$checkRole->execute(array($role));
								$checkRole = $checkRole->fetch(PDO::FETCH_ASSOC);
								if ($checkRole) {
									$checkAccountRole = db()->prepare("SELECT * FROM AccountRoles WHERE accountID = ? AND roleID = ?");
									$checkAccountRole->execute(array($readAccount["id"], $role));
									if ($checkAccountRole->rowCount() > 0) {
										$readCheckAccountRole = $checkAccountRole->fetch();
										$expiryDate = $readProduct["duration"] <= 0 ? "1000-01-01 00:00:00" : createDuration(getDuration($readCheckAccountRole["expiryDate"]) + $readProduct["duration"]);
										$updateRole = db()->prepare("UPDATE AccountRoles SET expiryDate = ? WHERE accountID = ? AND roleID = ?");
										$updateRole->execute(array($expiryDate, $readAccount["id"], $role));
									} else {
										$expiryDate = $readProduct["duration"] <= 0 ? "1000-01-01 00:00:00" : createDuration($readProduct["duration"]);
										$giveRole = db()->prepare("INSERT INTO AccountRoles (accountID, roleID, expiryDate) VALUES (?, ?, ?)");
										$giveRole->execute(array($readAccount["id"], $role, $expiryDate));
									}
									
									// If the role has a discordRoleID, push to discordRoles array
									if (DiscordBotService::isBotReady() && $checkRole["discordRoleID"] != '' && $checkRole["discordRoleID"] != null) {
										$discordRoles[$checkRole["id"]] = [
											'id' => $checkRole["discordRoleID"],
											'expiryDate' => $expiryDate
										];
									}
								}
							}
							if (count($roles) > 0) {
								// Legacy Discord Bot
								if (modules('discord')->isActive() && modules('discord')->settings('roleSyncingStatus') == 1) {
									$accountDiscordID = null;
									if (settings('loginProvider') == 'discord') {
										$accountDiscordID = $readAccount["username"];
									} else {
										$accountDiscordData = db()->prepare("SELECT * FROM AccountDiscordData WHERE accountID = ?");
										$accountDiscordData->execute(array($readAccount["id"]));
										$accountDiscordData = $accountDiscordData->fetch();
										if ($accountDiscordData) {
											$accountDiscordID = $accountDiscordData["discordUserID"];
										}
									}
									if ($accountDiscordID) {
										JobDispatcher::dispatch((new ResyncDiscordLegacy($accountDiscordID)));
									}
								}
							}
						}
					}
					
					// Subscription
					if ($readProduct["isCumulative"] == '1') {
						$subs = db()->prepare("SELECT * FROM Subscriptions S INNER JOIN Products P ON P.id = S.productID WHERE P.categoryID = ? AND accountID = ? AND (endsAt > ? OR endsAt = '1000-01-01 00:00:00') ORDER BY P.priority ASC LIMIT 1");
						$subs->execute(array($readProduct["categoryID"], $readAccount["id"], datetime()));
						$subs = $subs->fetch(PDO::FETCH_ASSOC);
						
						// If subscription exists, cancel it
						if ($subs) {
							$updateSubscriptions = db()->prepare("UPDATE Subscriptions SET endsAt = ?, isCancelled = ? WHERE id = ?");
							$updateSubscriptions->execute(array(datetime(), 1, $subs["id"]));
						}
						if ($readProduct["duration"] >= 0) {
							$insertSubscriptions = db()->prepare("INSERT INTO Subscriptions (accountID, productID, startsAt, endsAt, creationDate) VALUES (?, ?, ?, ?, ?)");
							$insertSubscriptions->execute(array($readAccount["id"], $readProduct["id"], datetime(), $readProduct["duration"] == 0 ? '1000-01-01 00:00:00' : createDuration($readProduct["duration"]), datetime()));
						}
					}
					
					// Add to Purchased Products
					$checkPurchasedProduct = db()->prepare("SELECT * FROM PurchasedProducts WHERE accountID = ? AND productID = ?");
					$checkPurchasedProduct->execute(array($readAccount["id"], $readProduct["id"]));
					$checkPurchasedProduct = $checkPurchasedProduct->fetch();
					
					// If product is not purchased, add it to PurchasedProducts
					if (!$checkPurchasedProduct) {
						$insertPurchasedProducts = db()->prepare("INSERT INTO PurchasedProducts (accountID, productID, expiresAt, purchasedAt) VALUES (?, ?, ?, ?)");
						$insertPurchasedProducts->execute(array($readAccount["id"], $readProduct["id"], ($readProduct["duration"] > 0 ? createDuration($readProduct["duration"]) : null), datetime()));
					}
					// If product is purchased but expired, update it
					else if ($checkPurchasedProduct["expiresAt"] < datetime() && $checkPurchasedProduct["expiresAt"] != null) {
						$updatePurchasedProducts = db()->prepare("UPDATE PurchasedProducts SET expiresAt = ? WHERE accountID = ? AND productID = ? AND expiresAt IS NOT NULL");
						$updatePurchasedProducts->execute(array(($readProduct["duration"] > 0 ? createDuration($readProduct["duration"]) : null), $readAccount["id"], $readProduct["id"]));
					}
				}
			}
			
			// Discord Bot
			if (DiscordBotService::isBotReady()) {
				$discordRoles = array_values($discordRoles);
				
				if (count($discordRoles) > 0) {
					$accountDiscordID = null;
					if (settings('loginProvider') == 'discord') {
						$accountDiscordID = $readAccount["username"];
					} else {
						$loginConnection = db()->prepare('SELECT L.identifier FROM LinkedAccounts L INNER JOIN AccountLinkingProviders P ON P.id = L.providerID WHERE P.slug = ? AND L.accountID = ?');
						$loginConnection->execute(['discord', $readAccount["id"]]);
						$loginConnection = $loginConnection->fetch();
						if ($loginConnection) {
							$accountDiscordID = $loginConnection["identifier"];
						}
					}
					
					if ($accountDiscordID) {
						// Request to discord bot api
						JobDispatcher::dispatch((new AddDiscordRoles($accountDiscordID, $discordRoles)));
					}
				}
			}

			// Send commands
			$servers = [];
			foreach ($products as $product) {
				$productCommands = db()->prepare("SELECT PC.id, PC.command, PC.serverID FROM ProductCommands PC INNER JOIN Products P ON PC.productID = P.id WHERE PC.productID = ? AND PC.isActive = ?");
				$productCommands->execute(array($product["id"], 1));
				$productCommands = $productCommands->fetchAll();
				
				foreach ($productCommands as $productCommand) {
					// Replace custom variables
					$variables = [
						"%username%" => $readAccount["realname"],
						"%display_name%" => $readAccount["realname"],
					];
					if (settings('loginProvider') == 'steam') {
						$variables["%steam_id%"] = $readAccount["username"];
					}
					if (settings('loginProvider') == 'discord') {
						$variables["%discord_id%"] = $readAccount["username"];
					}
					if (settings('loginProvider') == 'cfx') {
						$variables["%cfx_id%"] = $readAccount["username"];
					}
					if (settings('loginProvider') == 'minecraft') {
						$variables["%uuid%"] = $readAccount["username"];
					}
					
					// Variables from Account Linking
					if (modules('account_linking')->isActive()) {
						$linkedAccounts = db()->prepare("SELECT L.*, P.slug FROM LinkedAccounts L INNER JOIN AccountLinkingProviders P ON P.id = L.providerID WHERE L.accountID = ?");
						$linkedAccounts->execute(array($readAccount["id"]));
						$linkedAccounts = $linkedAccounts->fetchAll();
						foreach ($linkedAccounts as $linkedAccount) {
							if ($linkedAccount["slug"] == 'minecraft') {
								$variables["%minecraft_uuid%"] = $linkedAccount["identifier"];
								$variables["%minecraft_username%"] = $linkedAccount["displayName"];
							} else {
								$variables["%" . $linkedAccount['slug'] . "_id%"] = $linkedAccount["identifier"];
								$variables["%" . $linkedAccount['slug'] . "_username%"] = $linkedAccount["displayName"];
							}
						}
					}
					
					if (isset($product["variables"])) {
						foreach ($product["variables"] as $variableIdentifier => $variableValue) {
							$variables["%$variableIdentifier%"] = $variableValue;
						}
					}
					$command = $productCommand["command"];
					$command = str_replace(
						array_keys($variables),
						array_values($variables),
						$command
					);
					
					for ($i = 0; $i < $product["quantity"]; $i++) {
						$insertCommandLogs = db()->prepare("INSERT INTO CommandLogs (dataType, dataID, commandID, identifier, command, status, updatedAt, creationDate) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
						$insertCommandLogs->execute([
							$dataType,
							($dataType == 'chest' && $dataID == 0 && isset($product["chestID"])) ? $product["chestID"] : $dataID,
							$productCommand["id"],
							(settings('gameType') == 'minecraft' ? $readAccount["realname"] : $readAccount["username"]),
							$command,
							'sending',
							datetime(),
							datetime()
						]);
						
						$servers[$productCommand["serverID"]][] = [
							'command' => $command,
							'logID' => db()->lastInsertId()
						];
					}
				}
			}
			foreach ($servers as $serverID => $commands) {
				$server = db()->prepare("SELECT * FROM Servers WHERE id = ?");
				$server->execute(array($serverID));
				$server = $server->fetch();
				
				JobDispatcher::dispatch((new SendCommand(
					$server["ip"],
					$server["consolePort"],
					$server["consolePassword"],
					$server["consoleToken"],
					$server["consoleID"],
					$commands
				)));
			}
		}
	}