<?php
	namespace Main\Services;
	
	use Main\Libs\DiscordWebhook;
	use PDO;
	
	class DiscordWebhookService
	{
		public static function send($event, $variables)
		{
			$discordWebhooks = db()->prepare("SELECT * FROM DiscordWebhooks WHERE event = ? AND isActive = '1'");
			$discordWebhooks->execute([$event]);
			$discordWebhooks = $discordWebhooks->fetchAll(PDO::FETCH_ASSOC);
			
			foreach ($discordWebhooks as $webhook) {
				$webhook = new DiscordWebhook(
					$webhook["event"],
					$webhook["url"],
					$webhook["botName"],
					$webhook["botAvatar"],
					$webhook["data"],
					(array)$variables
				);
				$webhook->send();
			}
		}
	}