<?php
	namespace Main\Services;
	
	class MoneyService
	{
		public static function credits($amount): string
		{
			$credits = formatMoney($amount, modules('store')->settings('removeMoneyZeroDecimal') == 1);
			
			if (modules('credit')->settings('creditText') != "" && modules('credit')->settings('creditText') != null)
				return $credits." ".modules('credit')->settings('creditText');
			
			return t__('%credit% credit(s)', ['%credit%' => $credits]);
		}
	}