<?php
	namespace Main\Services;
	
	use Exception;
	use Main\Libs\Parasut;
	
	class ParasutService
	{
		/**
		 * @throws Exception
		 */
		public static function createInvoice($orderID)
		{
			// Get Order
			$order = db()->prepare("SELECT * FROM Orders WHERE id = ?");
			$order->execute(array($orderID));
			$order = $order->fetch();
			if (!$order)
				throw new Exception("Order not found");
			
			$accountID = $order["accountID"];
			
			$parasut = new Parasut(modules('parasut')->settings('clientID'), modules('parasut')->settings('clientSecret'), modules('parasut')->settings('companyID'));
			
			$accessToken = modules('parasut')->settings('accessToken');
			$refreshToken = modules('parasut')->settings('refreshToken');
			$expiryDate = modules('parasut')->settings('tokenExpiryDate');

			// Refresh Token
			if ($expiryDate <= datetime()) {
				try {
					$refreshTokenResponse = $parasut->refreshAccessToken(modules('parasut')->settings('refreshToken'));
					$accessToken = $refreshTokenResponse->access_token;
					$refreshToken = $refreshTokenResponse->refresh_token;
					$expiryDate = date('Y-m-d H:i:s', time() + $refreshTokenResponse->expires_in);
					
					modules('parasut')->updateSettings([
						"accessToken" => $accessToken,
						"refreshToken" => $refreshToken,
						"tokenExpiryDate" => $expiryDate,
					]);
				} catch (Exception $e) {
					throw new Exception("Refresh Token failed");
				}
			}

			// Get Customer
			$user = db()->prepare("SELECT A.id, A.email, ACI.* FROM Accounts A INNER JOIN AccountContactInfo ACI ON A.id = ACI.accountID WHERE A.id = ?");
			$user->execute(array($accountID));
			$user = $user->fetch();
			if (!$user)
				throw new Exception("User not found");
			
			$parasutCustomer = db()->prepare("SELECT * FROM AccountParasutData WHERE accountID = ?");
			$parasutCustomer->execute(array($accountID));
			$parasutCustomer = $parasutCustomer->fetch();
			
			if (!$parasutCustomer) {
				// If customer not found, create a new one
				$parasutCustomerQuery = $parasut->createCustomer($accessToken, sprintf('%s %s', $user["firstName"], $user["lastName"]), $user["email"]);
				$parasutCustomerID = $parasutCustomerQuery->data->id;
				
				// Save Customer ID to database
				$createAccountParasutData = db()->prepare("INSERT INTO AccountParasutData (accountID, contactID) VALUES (?, ?)");
				$createAccountParasutData->execute(array($accountID, $parasutCustomerID));
			}
			else {
				// If customer found, get customer ID
				$parasutCustomerID = $parasutCustomer["contactID"];
			}

			// Create Invoice
			$invoice = $parasut->createInvoice(
				$accessToken,
				$parasutCustomerID,
				$order["id"],
				modules('parasut')->settings('productID'),
				$order["total"]
			);
			$invoiceID = $invoice->data->id;

			// Pay Invoice
			$payInvoice = $parasut->payInvoice(
				$accessToken,
				$invoiceID,
				modules('parasut')->settings('accountID'),
				$order["total"]
			);

			// Sign E-Archive
			$signEArchive = $parasut->signEArchive(
				$accessToken,
				$invoiceID,
				$order["paymentAPI"]
			);
		}
	}