<?php
	namespace Main\Services;
	
	use PDO;
	
	class ProductService
	{
		public static function product($product, $subscription = null)
		{
			$discountProducts = explode(",", modules('store')->settings('discountProducts'));
			$product["subsDiscountStatus"] = $subscription != null && $product["priority"] < $subscription["priority"];
			$product["discountedPriceStatus"] = ($product["discountedPrice"] != 0 && ($product["discountExpiryDate"] > datetime() || $product["discountExpiryDate"] == '1000-01-01 00:00:00'));
			$product["storeDiscountStatus"] = (modules('store')->settings('discount') != 0 && (in_array($product["id"], $discountProducts) || modules('store')->settings('discountProducts') == '0') && (modules('store')->settings('discountExpiryDate') > datetime() || modules('store')->settings('discountExpiryDate') == '1000-01-01 00:00:00'));
			$product["discounted"] = $product["subsDiscountStatus"] || $product["discountedPriceStatus"] || $product["storeDiscountStatus"];
			
			$product["discountPercent"] = 0;
			if ($product["discountedPriceStatus"]) {
				$product["discountPercent"] = round((($product["price"]-$product["discountedPrice"])*100)/($product["price"]));
			} else if ($product["storeDiscountStatus"]) {
				$product["discountedPrice"] = ($product["price"]*(100-modules('store')->settings('discount')))/100;
				$product["discountPercent"] = modules('store')->settings('discount');
			}
			
			if ($product["subsDiscountStatus"]) {
				if ($subscription["endsAt"] == '1000-01-01 00:00:00') {
					$product["discountedPrice"] = ($product["discountedPriceStatus"] || $product["storeDiscountStatus"] ? $product["discountedPrice"] : $product["price"]) - ($subscription["price"]);
				} else {
					$product["discountedPrice"] = ($product["discountedPriceStatus"] || $product["storeDiscountStatus"] ? $product["discountedPrice"] : $product["price"]) - ((($subscription["price"]) * (strtotime($subscription["endsAt"]) - time())) / (strtotime($subscription["endsAt"]) - strtotime($subscription["startsAt"])));
				}
				$product["discountPercent"] = round((($product["price"]-$product["discountedPrice"])*100)/($product["price"]));
			}
			
			$product["upgradable"] = $subscription != null && $product["priority"] < $subscription["priority"];
			$product["downgradable"] = $subscription != null && $product["priority"] > $subscription["priority"];
			$product["restricted"] = $subscription != null && $product["priority"] >= $subscription["priority"];
			
			$product["total"] = $product["discounted"] ? $product["discountedPrice"] : $product["price"];
			$product["subtotal"] = $product["price"];
			$product["tax"] = (modules('store')->settings('tax') > 0 && modules('store')->settings('isCreditRequiredOnPurchase') == 0 ? ($product["total"] * modules('store')->settings('tax')) / 100 : 0);
			$product["total"] += $product["tax"];
			$product["discount"] = $product["discounted"] ? $product["price"] - $product["discountedPrice"] : 0;
			
			$product["image"] = "/assets/core/images/store/products/" . $product["imageID"] . "." . $product["imageType"];
			
			return $product;
		}
		public static function listing($products, $subscription = null): array
		{
			return array_map(function ($product) use ($subscription) {
				return self::product($product, $subscription);
			}, $products);
		}
		
		public static function getCategoryListRecursive($categoryID, $list = [])
		{
			$category = db()->prepare("SELECT id, name, parentID FROM ProductCategories WHERE id = ?");
			$category->execute(array($categoryID));
			$category = $category->fetch(PDO::FETCH_ASSOC);
			
			if (!$category) return [];
			
			$list[$category["id"]] = $category["name"];
			
			if ($category["parentID"] != 0) {
				return getCategoryListRecursive($category["parentID"], $list);
			}
			
			return $list;
		}
	}