<?php
	
	namespace Main\Services;
	
	use Main\Core\Seo;
	
	class SeoService {
		private static $instance = null;
		private static array $pages = [];
		private $seo;
		
		public static function set($page, $data = []) {
			if (self::$instance === null) {
				self::$instance = new self();
			}
			if (!isset(self::$pages[$page])) {
				$seoPages = db()->prepare("SELECT * FROM SeoPages WHERE page = ?");
				$seoPages->execute([$page]);
				$seoPage = $seoPages->fetch();
				if ($seoPage) {
					self::$pages[$page] = new Seo(
						$seoPage['page'],
						$seoPage['title'],
						$seoPage['description'],
						$seoPage['image'],
						$data
					);
				} else {
					self::$pages[$page] = new Seo(
						$page,
						$data['title'] ?? settings('serverName'),
						$data['description'] ?? "",
						$data['image'] ?? "",
						$data
					);
				}
			}
			self::$instance->seo = self::$pages[$page];
		}
		
		public static function getSeo(): Seo {
			if (self::$instance === null || self::$instance->seo === null) {
				self::set('home');
			}
			return self::$instance->seo;
		}
	}