<?php
	namespace Main\Services;
	
	use PDO;
	
	class SubscriptionService
	{
		public static function getSubscriptionByCategory($category)
		{
			$discountProducts = explode(",", modules('store')->settings('discountProducts'));
			$subs = null;
			if ($category["isCumulative"] == '1' && auth()->check()) {
				$subs = db()->prepare("SELECT * FROM Subscriptions S INNER JOIN Products P ON P.id = S.productID WHERE P.categoryID = ? AND accountID = ? AND (endsAt > ? OR endsAt = '1000-01-01 00:00:00') ORDER BY P.priority ASC LIMIT 1");
				$subs->execute(array($category["id"], auth()->user()->id(), datetime()));
				$subs = $subs->fetch(PDO::FETCH_ASSOC);
				if ($subs) {
					if ($subs["discountedPrice"] > 0 && ($subs["discountExpiryDate"] > datetime() || $subs["discountExpiryDate"] == '1000-01-01 00:00:00'))
						$subs["price"] = $subs["discountedPrice"];
					else if (modules('store')->settings('discount') != 0 && (in_array($subs["productID"], $discountProducts) || modules('store')->settings('discountProducts') == '0') && (modules('store')->settings('discountExpiryDate') > datetime() || modules('store')->settings('discountExpiryDate') == '1000-01-01 00:00:00'))
						$subs["price"] = ($subs["price"] * (100 - modules('store')->settings('discount'))) / 100;
				}
			}
			
			return $subs;
		}
	}