<?php
  namespace Main\Services;
  
  use PDO;
  use Verot\Upload\Upload;
  
  class UserService
  {
    public static function get($user)
    {
			if (!$user || $user == "") return false;
			
      if (is_numeric($user))
        $account = db()->prepare("SELECT * FROM Accounts WHERE id = ?");
      else
        $account = db()->prepare("SELECT * FROM Accounts WHERE realname = ?");

      $account->execute([$user]);
      if ($account->rowCount() === 0) return false;
      
      return $account->fetch(PDO::FETCH_ASSOC);
    }

    public static function getByDiscordUserID($discordUserID)
    {
      $account = db()->prepare("SELECT A.*, ADC.discordUserID FROM AccountDiscordData ADC INNER JOIN Accounts A ON A.id = ADC.accountID WHERE ADC.discordUserID = ?");
      $account->execute([$discordUserID]);
      if ($account->rowCount() === 0) return false;

      return $account->fetch(PDO::FETCH_ASSOC);
    }
		
		public static function getRoles($id): array
		{
			static $defaultRole = null;
			$roles = [];
			$accountRoles = db()->prepare("SELECT R.*, AR.expiryDate FROM AccountRoles AR INNER JOIN Roles R ON AR.roleID = R.id WHERE AR.accountID = ? AND (AR.expiryDate > ? OR AR.expiryDate = ?) ORDER BY R.priority DESC");
			$accountRoles->execute(array($id, datetime(), '1000-01-01 00:00:00'));
			if ($accountRoles->rowCount() > 0) {
				$roles = $accountRoles->fetchAll(PDO::FETCH_ASSOC);
			}
			else {
				if ($defaultRole == null) {
					$defaultRole = db()->prepare("SELECT * FROM Roles WHERE slug = ?");
					$defaultRole->execute(array('default'));
					$defaultRole = $defaultRole->fetch(PDO::FETCH_ASSOC);
				}
				return [ $defaultRole ];
			}
			return $roles;
		}
		
		public static function getPermissions($id): array
		{
			$permissions = [];
			
			$roles = db()->prepare("SELECT * FROM AccountRoles WHERE accountID = ? AND (expiryDate > ? OR expiryDate = ?)");
			$roles->execute(array($id, datetime(), '1000-01-01 00:00:00'));
			$roles = $roles->fetchAll(PDO::FETCH_ASSOC);
			
			$rolePermissionsQuery = db()->prepare("SELECT P.id, P.name FROM RolePermissions RP INNER JOIN Permissions P ON P.id = RP.permissionID WHERE RP.roleID = ?");
			foreach ($roles as $role) {
				$rolePermissionsQuery->execute(array($role["roleID"]));
				$rolePermissions = $rolePermissionsQuery->fetchAll(PDO::FETCH_ASSOC);
				foreach ($rolePermissions as $rolePermission) {
					$permissions[] = $rolePermission["name"];
				}
			}
			$extraPermissions = db()->prepare("SELECT P.id, P.name FROM AccountPermissions AP INNER JOIN Permissions P ON P.id = AP.permissionID WHERE AP.accountID = ?");
			$extraPermissions->execute(array($id));
			$extraPermissions = $extraPermissions->fetchAll(PDO::FETCH_ASSOC);
			foreach ($extraPermissions as $extraPermission) {
				$permissions[] = $extraPermission["name"];
			}
			
			return $permissions;
		}
		
		public static function getSupportPermissions($id): array
		{
			$permissions = [];
			
			$permissions['STRICT_MANAGE_SUPPORT_TICKETS'] = false;
			
			$roles = db()->prepare("SELECT * FROM AccountRoles WHERE accountID = ? AND (expiryDate > ? OR expiryDate = ?)");
			$roles->execute(array($id, datetime(), '1000-01-01 00:00:00'));
			$roles = $roles->fetchAll(PDO::FETCH_ASSOC);
			
			$rolePermissionsQuery = db()->prepare("SELECT P.id, P.name, RP.categoryID FROM SupportCategoryRolePermissions RP INNER JOIN SupportCategoryPermissions P ON P.id = RP.permissionID WHERE RP.roleID = ?");
			foreach ($roles as $role) {
				$rolePermissionsQuery->execute(array($role["roleID"]));
				$rolePermissions = $rolePermissionsQuery->fetchAll(PDO::FETCH_ASSOC);
				foreach ($rolePermissions as $rolePermission) {
					$permissions[$rolePermission["name"]][] = $rolePermission["categoryID"];
				}
			}
			$extraPermissions = db()->prepare("SELECT P.id, P.name FROM AccountPermissions AP INNER JOIN Permissions P ON P.id = AP.permissionID WHERE AP.accountID = ? AND P.name = ? LIMIT 1");
			$extraPermissions->execute(array($id, 'MANAGE_SUPPORT_TICKETS'));
			$extraPermissions = $extraPermissions->fetch(PDO::FETCH_ASSOC);
			if ($extraPermissions) {
				$permissions['STRICT_MANAGE_SUPPORT_TICKETS'] = true;
			}
			
			return $permissions;
		}
		
		public static function isStaff($permissions): bool
		{
			return in_array('SUPER_ADMIN', $permissions) || in_array('VIEW_DASHBOARD', $permissions);
		}
	  
	  public static function uploadAvatarFromUrl($userID, $url)
	  {
		  // Generate a unique filename
		  $imageID = rand_token();
		  $extension = "jpg"; // Assuming the image is always in JPG format
		  
		  // Define the save path
		  $savePath = __ROOT__ . "/apps/main/public/images/avatars/";
		  $newFile = $savePath . $imageID . "." . $extension;
		  
		  // Download and save the image directly
		  file_put_contents($newFile, file_get_contents($url));
			
			// Crop and resize image
		  ImageCropService::processAvatar($newFile, 256);
		  
		  // Delete previous avatar if exists
		  $checkAvatar = db()->prepare("SELECT * FROM Avatars WHERE accountID = ?");
		  $checkAvatar->execute([$userID]);
		  $checkAvatar = $checkAvatar->fetch();
		  
		  if ($checkAvatar) {
			  $deleteAvatar = db()->prepare("DELETE FROM Avatars WHERE accountID = ?");
			  $deleteAvatar->execute([$userID]);
			  @unlink($savePath . $checkAvatar["imageID"] . "." . $checkAvatar["imageType"]);
		  }
		  
		  // Insert new avatar into the database
		  $insertAvatar = db()->prepare("INSERT INTO Avatars (accountID, imageID, imageType) VALUES (?, ?, ?)");
		  $insertAvatar->execute([$userID, $imageID, $extension]);
	  }
  }