<?php if ($pageCount > 0): ?>
	<ul class="pagination ">
		<li class="page-item">
			<a class="page-link" href="<?php echo $page == 1 ? "#!" : "?page=" . ($page-1) ?>" tabindex="-1">
				<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M15 6l-6 6l6 6"></path></svg>
			</a>
		</li>
		
		<?php for ($i = $page - 5; $i < $page + 5 + 1; $i++): ?>
			<?php if ($i > 0 and $i <= $pageCount): ?>
				<li class="page-item <?php echo (($page == $i) ? "active" : null); ?> d-none d-sm-block" <?php echo ($page == $i) ? 'aria-current="page"' : null ?> >
					<a class="page-link" href="<?php echo '?page='.$i; ?>"><?php echo $i; ?></a>
				</li>
			<?php endif; ?>
		<?php endfor; ?>
		
		<li class="page-item">
			<a class="page-link" href="<?php echo $page == $pageCount ? "#!" : "?page=" . ($page+1) ?>" aria-disabled="<?php echo $page == $pageCount ? "true" : "false" ?>">
				<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M9 6l6 6l-6 6"></path></svg>
			</a>
		</li>
	</ul>
<?php endif; ?>